/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.postgresql.visitor.statement.impl;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.autogen.PostgreSQLStatementBaseVisitor;
import org.apache.shardingsphere.sql.parser.autogen.PostgreSQLStatementParser;
import org.apache.shardingsphere.sql.parser.sql.common.constant.AggregationType;
import org.apache.shardingsphere.sql.parser.sql.common.constant.OrderDirection;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationDistinctProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.LimitValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.NumberLiteralLimitValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.ParameterMarkerLimitValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.LockSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DataTypeLengthSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.WindowSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.keyword.KeywordValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.LiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.BooleanLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.parametermarker.ParameterMarkerValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.ddl.PostgreSQLExecuteStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dml.PostgreSQLDeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dml.PostgreSQLInsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dml.PostgreSQLSelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dml.PostgreSQLUpdateStatement;

public abstract class PostgreSQLStatementSQLVisitor
extends PostgreSQLStatementBaseVisitor<ASTNode> {
    private int currentParameterIndex;

    public PostgreSQLStatementSQLVisitor(Properties props) {
    }

    @Override
    public final ASTNode visitParameterMarker(PostgreSQLStatementParser.ParameterMarkerContext ctx) {
        return new ParameterMarkerValue(Integer.valueOf(this.currentParameterIndex++));
    }

    @Override
    public final ASTNode visitNumberLiterals(PostgreSQLStatementParser.NumberLiteralsContext ctx) {
        return new NumberLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitIdentifier(PostgreSQLStatementParser.IdentifierContext ctx) {
        PostgreSQLStatementParser.UnreservedWordContext unreservedWord = ctx.unreservedWord();
        return null != unreservedWord ? (ASTNode)this.visit((ParseTree)unreservedWord) : new IdentifierValue(ctx.getText());
    }

    @Override
    public final ASTNode visitUnreservedWord(PostgreSQLStatementParser.UnreservedWordContext ctx) {
        return new IdentifierValue(ctx.getText());
    }

    @Override
    public final ASTNode visitSchemaName(PostgreSQLStatementParser.SchemaNameContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.identifier());
    }

    @Override
    public final ASTNode visitTableName(PostgreSQLStatementParser.TableNameContext ctx) {
        SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name())));
        PostgreSQLStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        return result;
    }

    @Override
    public final ASTNode visitColumnName(PostgreSQLStatementParser.ColumnNameContext ctx) {
        ColumnSegment result = new ColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name()));
        PostgreSQLStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        return result;
    }

    @Override
    public final ASTNode visitIndexName(PostgreSQLStatementParser.IndexNameContext ctx) {
        return new IndexSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public final ASTNode visitConstraintName(PostgreSQLStatementParser.ConstraintNameContext ctx) {
        return new ConstraintSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public final ASTNode visitTableNames(PostgreSQLStatementParser.TableNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (PostgreSQLStatementParser.TableNameContext each : ctx.tableName()) {
            result.getValue().add((SimpleTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitColumnNames(PostgreSQLStatementParser.ColumnNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (PostgreSQLStatementParser.ColumnNameContext each : ctx.columnName()) {
            result.getValue().add((ColumnSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitAExpr(PostgreSQLStatementParser.AExprContext ctx) {
        if (null != ctx.cExpr()) {
            return (ASTNode)this.visit((ParseTree)ctx.cExpr());
        }
        if (null != ctx.BETWEEN()) {
            return this.createBetweenSegment(ctx);
        }
        if (null != ctx.IN()) {
            return this.createInSegment(ctx);
        }
        if (null != ctx.patternMatchingOperator()) {
            return this.createPatternMatchingOperationSegment(ctx);
        }
        if (null != ctx.comparisonOperator()) {
            return this.createCommonBinaryOperationSegment(ctx, ctx.comparisonOperator().getText());
        }
        if (null != ctx.logicalOperator()) {
            return this.createCommonBinaryOperationSegment(ctx, ctx.logicalOperator().getText());
        }
        super.visitAExpr(ctx);
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), text);
    }

    private BinaryOperationExpression createPatternMatchingOperationSegment(PostgreSQLStatementParser.AExprContext ctx) {
        String operator = ctx.patternMatchingOperator().getText();
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr(0));
        ListExpression right = new ListExpression(ctx.aExpr((int)1).start.getStartIndex(), ctx.aExpr().get((int)(ctx.aExpr().size() - 1)).stop.getStopIndex());
        for (int i = 1; i < ctx.aExpr().size(); ++i) {
            right.getItems().add((ExpressionSegment)this.visit((ParseTree)ctx.aExpr().get(i)));
        }
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, (ExpressionSegment)right, operator, text);
    }

    private BinaryOperationExpression createCommonBinaryOperationSegment(PostgreSQLStatementParser.AExprContext ctx, String operator) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr(0));
        ExpressionSegment right = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr(1));
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    @Override
    public ASTNode visitCExpr(PostgreSQLStatementParser.CExprContext ctx) {
        if (null != ctx.columnref()) {
            return (ASTNode)this.visit((ParseTree)ctx.columnref());
        }
        if (null != ctx.parameterMarker()) {
            return new ParameterMarkerExpressionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ((ParameterMarkerValue)this.visit((ParseTree)ctx.parameterMarker())).getValue().intValue());
        }
        if (null != ctx.aexprConst()) {
            ASTNode astNode = (ASTNode)this.visit((ParseTree)ctx.aexprConst());
            if (astNode instanceof StringLiteralValue || astNode instanceof BooleanLiteralValue || astNode instanceof NumberLiteralValue) {
                return new LiteralExpressionSegment(ctx.aexprConst().start.getStartIndex(), ctx.aexprConst().stop.getStopIndex(), ((LiteralValue)astNode).getValue());
            }
            return astNode;
        }
        if (null != ctx.aExpr()) {
            return (ASTNode)this.visit((ParseTree)ctx.aExpr());
        }
        if (null != ctx.funcExpr()) {
            return (ASTNode)this.visit((ParseTree)ctx.funcExpr());
        }
        super.visitCExpr(ctx);
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new CommonExpressionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), text);
    }

    @Override
    public ASTNode visitFuncExpr(PostgreSQLStatementParser.FuncExprContext ctx) {
        this.calculateParameterCount(this.getTargetRuleContextFromParseTree((ParseTree)ctx, PostgreSQLStatementParser.CExprContext.class));
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), text);
    }

    private <T extends ParseTree> Collection<T> getTargetRuleContextFromParseTree(ParseTree parseTree, Class<? extends T> clazz) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (int index = 0; index < parseTree.getChildCount(); ++index) {
            ParseTree child = parseTree.getChild(index);
            if (clazz.isInstance(child)) {
                result.add(clazz.cast(child));
                continue;
            }
            result.addAll(this.getTargetRuleContextFromParseTree(child, clazz));
        }
        return result;
    }

    private void calculateParameterCount(Collection<PostgreSQLStatementParser.CExprContext> cexprContexts) {
        for (PostgreSQLStatementParser.CExprContext each : cexprContexts) {
            this.visit((ParseTree)each);
        }
    }

    @Override
    public ASTNode visitAexprConst(PostgreSQLStatementParser.AexprConstContext ctx) {
        if (null != ctx.NUMBER_()) {
            return new NumberLiteralValue(ctx.NUMBER_().getText());
        }
        if (null != ctx.STRING_()) {
            return new StringLiteralValue(ctx.STRING_().getText());
        }
        if (null != ctx.FALSE()) {
            return new BooleanLiteralValue(ctx.FALSE().getText());
        }
        if (null != ctx.TRUE()) {
            return new BooleanLiteralValue(ctx.TRUE().getText());
        }
        return new CommonExpressionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.getText());
    }

    @Override
    public ASTNode visitColumnref(PostgreSQLStatementParser.ColumnrefContext ctx) {
        if (null != ctx.indirection()) {
            PostgreSQLStatementParser.AttrNameContext attrName = ctx.indirection().indirectionEl().attrName();
            ColumnSegment result = new ColumnSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(attrName.getText()));
            OwnerSegment owner = new OwnerSegment(ctx.colId().start.getStartIndex(), ctx.colId().stop.getStopIndex(), new IdentifierValue(ctx.colId().getText()));
            result.setOwner(owner);
            return result;
        }
        return new ColumnSegment(ctx.colId().start.getStartIndex(), ctx.colId().stop.getStopIndex(), new IdentifierValue(ctx.colId().getText()));
    }

    private InExpression createInSegment(PostgreSQLStatementParser.AExprContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr(0));
        ExpressionSegment right = this.visitInExpression(ctx.inExpr());
        boolean not = null != ctx.NOT();
        return new InExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, not);
    }

    private ExpressionSegment visitInExpression(PostgreSQLStatementParser.InExprContext ctx) {
        if (null != ctx.selectWithParens()) {
            PostgreSQLSelectStatement select = (PostgreSQLSelectStatement)this.visit((ParseTree)ctx.selectWithParens());
            SubquerySegment subquerySegment = new SubquerySegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (SelectStatement)select);
            return new SubqueryExpressionSegment(subquerySegment);
        }
        return (ExpressionSegment)this.visit((ParseTree)ctx.exprList());
    }

    @Override
    public ASTNode visitExprList(PostgreSQLStatementParser.ExprListContext ctx) {
        ListExpression result = new ListExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        if (null != ctx.exprList()) {
            result.getItems().addAll(((ListExpression)this.visitExprList(ctx.exprList())).getItems());
        }
        result.getItems().add((ExpressionSegment)this.visit((ParseTree)ctx.aExpr()));
        return result;
    }

    private BetweenExpression createBetweenSegment(PostgreSQLStatementParser.AExprContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr(0));
        ExpressionSegment between = (ExpressionSegment)this.visit((ParseTree)ctx.bExpr());
        ExpressionSegment and = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr(1));
        boolean not = null != ctx.NOT();
        return new BetweenExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, between, and, not);
    }

    @Override
    public ASTNode visitBExpr(PostgreSQLStatementParser.BExprContext ctx) {
        if (null != ctx.cExpr()) {
            return (ASTNode)this.visit((ParseTree)ctx.cExpr());
        }
        if (null != ctx.TYPE_CAST_() || null != ctx.qualOp()) {
            ExpressionSegment right;
            String operator;
            ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bExpr(0));
            if (null != ctx.TYPE_CAST_()) {
                operator = ctx.TYPE_CAST_().getText();
                right = new CommonExpressionSegment(ctx.typeName().start.getStartIndex(), ctx.typeName().stop.getStopIndex(), ctx.typeName().getText());
            } else {
                operator = ctx.qualOp().getText();
                right = (ExpressionSegment)this.visit((ParseTree)ctx.bExpr(1));
            }
            String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
            return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
        }
        for (PostgreSQLStatementParser.BExprContext each : ctx.bExpr()) {
            this.visit((ParseTree)each);
        }
        return new LiteralExpressionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (Object)ctx.getText());
    }

    protected ProjectionSegment generateProjectFromFuncExpr(PostgreSQLStatementParser.FuncExprContext ctx) {
        if (null != ctx.funcApplication()) {
            return this.generateProjectFromFuncApplication(ctx.funcApplication());
        }
        return this.generateProjectFromFunctionExprCommonSubexpr(ctx.functionExprCommonSubexpr());
    }

    private ProjectionSegment generateProjectFromFuncApplication(PostgreSQLStatementParser.FuncApplicationContext ctx) {
        String aggregationType = ctx.funcName().getText();
        if (AggregationType.isAggregationType((String)aggregationType)) {
            return this.createAggregationSegment(ctx, aggregationType);
        }
        return new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    private ProjectionSegment generateProjectFromFunctionExprCommonSubexpr(PostgreSQLStatementParser.FunctionExprCommonSubexprContext ctx) {
        return new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    private ProjectionSegment createAggregationSegment(PostgreSQLStatementParser.FuncApplicationContext ctx, String aggregationType) {
        AggregationType type = AggregationType.valueOf((String)aggregationType.toUpperCase());
        String innerExpression = ctx.start.getInputStream().getText(new Interval(ctx.LP_().getSymbol().getStartIndex(), ctx.stop.getStopIndex()));
        if (null == ctx.DISTINCT()) {
            return new AggregationProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, innerExpression);
        }
        return new AggregationDistinctProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, innerExpression, this.getDistinctExpression(ctx));
    }

    private String getDistinctExpression(PostgreSQLStatementParser.FuncApplicationContext ctx) {
        StringBuilder result = new StringBuilder();
        result.append(ctx.funcArgList().getText());
        if (null != ctx.sortClause()) {
            result.append(ctx.sortClause().getText());
        }
        return result.toString();
    }

    @Override
    public final ASTNode visitDataTypeName(PostgreSQLStatementParser.DataTypeNameContext ctx) {
        PostgreSQLStatementParser.IdentifierContext identifierContext = ctx.identifier();
        if (null != identifierContext) {
            return new KeywordValue(identifierContext.getText());
        }
        LinkedList<String> dataTypeNames = new LinkedList<String>();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            dataTypeNames.add(ctx.getChild(i).getText());
        }
        return new KeywordValue(Joiner.on((String)" ").join(dataTypeNames));
    }

    @Override
    public final ASTNode visitSortClause(PostgreSQLStatementParser.SortClauseContext ctx) {
        LinkedList<OrderByItemSegment> items = new LinkedList<OrderByItemSegment>();
        for (PostgreSQLStatementParser.SortbyContext each : ctx.sortbyList().sortby()) {
            items.add((OrderByItemSegment)this.visit((ParseTree)each));
        }
        return new OrderBySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), items);
    }

    @Override
    public final ASTNode visitSortby(PostgreSQLStatementParser.SortbyContext ctx) {
        OrderDirection orderDirection = null != ctx.ascDesc() ? this.generateOrderDirection(ctx.ascDesc()) : OrderDirection.ASC;
        ASTNode astNode = (ASTNode)this.visit((ParseTree)ctx.aExpr());
        if (astNode instanceof ColumnSegment) {
            ColumnSegment column = (ColumnSegment)astNode;
            return new ColumnOrderByItemSegment(column, orderDirection);
        }
        if (astNode instanceof LiteralExpressionSegment) {
            LiteralExpressionSegment index = (LiteralExpressionSegment)astNode;
            return new IndexOrderByItemSegment(index.getStartIndex(), index.getStopIndex(), Integer.parseInt(index.getLiterals().toString()), orderDirection);
        }
        return new ExpressionOrderByItemSegment(ctx.aExpr().getStart().getStartIndex(), ctx.aExpr().getStop().getStopIndex(), ctx.aExpr().getText(), orderDirection);
    }

    private OrderDirection generateOrderDirection(PostgreSQLStatementParser.AscDescContext ctx) {
        return null == ctx.DESC() ? OrderDirection.ASC : OrderDirection.DESC;
    }

    @Override
    public final ASTNode visitDataType(PostgreSQLStatementParser.DataTypeContext ctx) {
        DataTypeSegment result = new DataTypeSegment();
        result.setDataTypeName(((KeywordValue)this.visit((ParseTree)ctx.dataTypeName())).getValue());
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        if (null != ctx.dataTypeLength()) {
            DataTypeLengthSegment dataTypeLengthSegment = (DataTypeLengthSegment)this.visit((ParseTree)ctx.dataTypeLength());
            result.setDataLength(dataTypeLengthSegment);
        }
        return result;
    }

    @Override
    public final ASTNode visitDataTypeLength(PostgreSQLStatementParser.DataTypeLengthContext ctx) {
        DataTypeLengthSegment result = new DataTypeLengthSegment();
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStartIndex());
        List<TerminalNode> numbers = ctx.NUMBER_();
        if (1 == numbers.size()) {
            result.setPrecision(Integer.parseInt(numbers.get(0).getText()));
        }
        if (2 == numbers.size()) {
            result.setPrecision(Integer.parseInt(numbers.get(0).getText()));
            result.setScale(Integer.parseInt(numbers.get(1).getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitInsert(PostgreSQLStatementParser.InsertContext ctx) {
        PostgreSQLInsertStatement result = (PostgreSQLInsertStatement)this.visit((ParseTree)ctx.insertRest());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.insertTarget()));
        result.setParameterCount(this.getCurrentParameterIndex());
        return result;
    }

    @Override
    public ASTNode visitInsertTarget(PostgreSQLStatementParser.InsertTargetContext ctx) {
        TableNameSegment tableName;
        PostgreSQLStatementParser.QualifiedNameContext qualifiedName = ctx.qualifiedName();
        OwnerSegment owner = null;
        if (null != qualifiedName.indirection()) {
            PostgreSQLStatementParser.ColIdContext colId = ctx.colId();
            owner = new OwnerSegment(colId.start.getStartIndex(), colId.stop.getStopIndex(), new IdentifierValue(colId.getText()));
            PostgreSQLStatementParser.AttrNameContext attrName = qualifiedName.indirection().indirectionEl().attrName();
            tableName = new TableNameSegment(attrName.start.getStartIndex(), attrName.stop.getStopIndex(), new IdentifierValue(attrName.getText()));
        } else {
            tableName = new TableNameSegment(qualifiedName.colId().start.getStartIndex(), qualifiedName.colId().stop.getStopIndex(), new IdentifierValue(qualifiedName.colId().getText()));
        }
        SimpleTableSegment result = new SimpleTableSegment(tableName);
        result.setOwner(owner);
        if (null != ctx.AS()) {
            PostgreSQLStatementParser.ColIdContext colId = ctx.colId();
            result.setAlias(new AliasSegment(colId.start.getStartIndex(), colId.stop.getStopIndex(), new IdentifierValue(colId.getText())));
        }
        return result;
    }

    @Override
    public ASTNode visitInsertRest(PostgreSQLStatementParser.InsertRestContext ctx) {
        PostgreSQLInsertStatement result = new PostgreSQLInsertStatement();
        if (null != ctx.insertColumnList()) {
            PostgreSQLStatementParser.InsertColumnListContext insertColumns = ctx.insertColumnList();
            CollectionValue columns = (CollectionValue)this.visit((ParseTree)insertColumns);
            InsertColumnsSegment insertColumnsSegment = new InsertColumnsSegment(insertColumns.start.getStartIndex() - 1, insertColumns.stop.getStopIndex() + 1, columns.getValue());
            result.setInsertColumns(insertColumnsSegment);
        } else {
            result.setInsertColumns(new InsertColumnsSegment(ctx.start.getStartIndex() - 1, ctx.start.getStartIndex() - 1, Collections.emptyList()));
        }
        PostgreSQLStatementParser.ValuesClauseContext valuesClause = ctx.select().selectNoParens().selectClauseN().simpleSelect().valuesClause();
        Collection<InsertValuesSegment> insertValuesSegments = this.createInsertValuesSegments(valuesClause);
        result.getValues().addAll(insertValuesSegments);
        return result;
    }

    @Override
    public ASTNode visitInsertColumnList(PostgreSQLStatementParser.InsertColumnListContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.insertColumnList()) {
            result.getValue().addAll(((CollectionValue)this.visit((ParseTree)ctx.insertColumnList())).getValue());
        }
        result.getValue().add((ColumnSegment)this.visit((ParseTree)ctx.insertColumnItem()));
        return result;
    }

    @Override
    public ASTNode visitInsertColumnItem(PostgreSQLStatementParser.InsertColumnItemContext ctx) {
        if (null != ctx.optIndirection().indirectionEl()) {
            ColumnSegment result = new ColumnSegment(ctx.colId().start.getStartIndex(), ctx.optIndirection().stop.getStopIndex(), new IdentifierValue(ctx.optIndirection().indirectionEl().attrName().getText()));
            result.setOwner(new OwnerSegment(ctx.colId().start.getStartIndex(), ctx.colId().stop.getStopIndex(), new IdentifierValue(ctx.colId().getText())));
            return result;
        }
        return new ColumnSegment(ctx.colId().start.getStartIndex(), ctx.colId().stop.getStopIndex(), new IdentifierValue(ctx.colId().getText()));
    }

    private Collection<InsertValuesSegment> createInsertValuesSegments(PostgreSQLStatementParser.ValuesClauseContext ctx) {
        Collection<InsertValuesSegment> expressions;
        LinkedList<InsertValuesSegment> result = new LinkedList<InsertValuesSegment>();
        if (null != ctx.valuesClause()) {
            expressions = this.createInsertValuesSegments(ctx.valuesClause());
            result.addAll(expressions);
        }
        expressions = this.createInsertValuesSegments(ctx.exprList());
        InsertValuesSegment insertValuesSegment = new InsertValuesSegment(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex(), (List)expressions);
        result.add(insertValuesSegment);
        return result;
    }

    private Collection<ExpressionSegment> createInsertValuesSegments(PostgreSQLStatementParser.ExprListContext ctx) {
        LinkedList<ExpressionSegment> result = new LinkedList<ExpressionSegment>();
        if (null != ctx.exprList()) {
            Collection<ExpressionSegment> tmpResult = this.createInsertValuesSegments(ctx.exprList());
            result.addAll(tmpResult);
        }
        ExpressionSegment expr = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr());
        result.add(expr);
        return result;
    }

    private Collection<AssignmentSegment> generateAssignmentSegments(PostgreSQLStatementParser.SetClauseListContext ctx) {
        LinkedList<AssignmentSegment> result = new LinkedList<AssignmentSegment>();
        if (null != ctx.setClauseList()) {
            Collection<AssignmentSegment> tmpResult = this.generateAssignmentSegments(ctx.setClauseList());
            result.addAll(tmpResult);
        }
        AssignmentSegment assignmentSegment = (AssignmentSegment)this.visit((ParseTree)ctx.setClause());
        result.add(assignmentSegment);
        return result;
    }

    @Override
    public ASTNode visitSetClause(PostgreSQLStatementParser.SetClauseContext ctx) {
        ColumnSegment columnSegment = (ColumnSegment)this.visit((ParseTree)ctx.setTarget());
        ExpressionSegment expressionSegment = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr());
        return new AssignmentSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), columnSegment, expressionSegment);
    }

    @Override
    public ASTNode visitSetTarget(PostgreSQLStatementParser.SetTargetContext ctx) {
        IdentifierValue identifierValue;
        OwnerSegment owner = null;
        if (null != ctx.optIndirection().indirectionEl()) {
            owner = new OwnerSegment(ctx.colId().start.getStartIndex(), ctx.colId().stop.getStopIndex(), new IdentifierValue(ctx.colId().getText()));
            identifierValue = new IdentifierValue(ctx.optIndirection().getText());
        } else {
            identifierValue = new IdentifierValue(ctx.colId().getText());
        }
        ColumnSegment result = new ColumnSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), identifierValue);
        result.setOwner(owner);
        return result;
    }

    @Override
    public ASTNode visitRelationExprOptAlias(PostgreSQLStatementParser.RelationExprOptAliasContext ctx) {
        SimpleTableSegment result;
        if (null != ctx.colId()) {
            PostgreSQLStatementParser.ColIdContext colId = ctx.relationExpr().qualifiedName().colId();
            result = new SimpleTableSegment(colId.start.getStartIndex(), colId.stop.getStopIndex(), new IdentifierValue(colId.getText()));
            result.setAlias(new AliasSegment(ctx.colId().start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(ctx.colId().getText())));
        } else {
            PostgreSQLStatementParser.ColIdContext colId = ctx.relationExpr().qualifiedName().colId();
            result = new SimpleTableSegment(colId.start.getStartIndex(), colId.stop.getStopIndex(), new IdentifierValue(colId.getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitUpdate(PostgreSQLStatementParser.UpdateContext ctx) {
        PostgreSQLUpdateStatement result = new PostgreSQLUpdateStatement();
        SimpleTableSegment tableSegment = (SimpleTableSegment)this.visit((ParseTree)ctx.relationExprOptAlias());
        result.setTableSegment((TableSegment)tableSegment);
        result.setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.setClauseList()));
        if (null != ctx.whereOrCurrentClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereOrCurrentClause()));
        }
        result.setParameterCount(this.getCurrentParameterIndex());
        return result;
    }

    @Override
    public ASTNode visitSetClauseList(PostgreSQLStatementParser.SetClauseListContext ctx) {
        Collection<AssignmentSegment> assignments = this.generateAssignmentSegments(ctx);
        return new SetAssignmentSegment(ctx.start.getStartIndex() - 4, ctx.stop.getStopIndex(), assignments);
    }

    @Override
    public ASTNode visitDelete(PostgreSQLStatementParser.DeleteContext ctx) {
        PostgreSQLDeleteStatement result = new PostgreSQLDeleteStatement();
        SimpleTableSegment tableSegment = (SimpleTableSegment)this.visit((ParseTree)ctx.relationExprOptAlias());
        result.setTableSegment((TableSegment)tableSegment);
        if (null != ctx.whereOrCurrentClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereOrCurrentClause()));
        }
        result.setParameterCount(this.getCurrentParameterIndex());
        return result;
    }

    @Override
    public ASTNode visitWhereOrCurrentClause(PostgreSQLStatementParser.WhereOrCurrentClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.whereClause());
    }

    @Override
    public ASTNode visitSelect(PostgreSQLStatementParser.SelectContext ctx) {
        PostgreSQLSelectStatement result = (PostgreSQLSelectStatement)this.visit((ParseTree)ctx.selectNoParens());
        result.setParameterCount(this.getCurrentParameterIndex());
        return result;
    }

    @Override
    public ASTNode visitSelectNoParens(PostgreSQLStatementParser.SelectNoParensContext ctx) {
        PostgreSQLSelectStatement result = (PostgreSQLSelectStatement)this.visit((ParseTree)ctx.selectClauseN());
        if (null != ctx.sortClause()) {
            OrderBySegment orderBySegment = (OrderBySegment)this.visit((ParseTree)ctx.sortClause());
            result.setOrderBy(orderBySegment);
        }
        if (null != ctx.selectLimit()) {
            LimitSegment limitSegment = (LimitSegment)this.visit((ParseTree)ctx.selectLimit());
            result.setLimit(limitSegment);
        }
        if (null != ctx.forLockingClause()) {
            LockSegment lockSegment = (LockSegment)this.visit((ParseTree)ctx.forLockingClause());
            result.setLock(lockSegment);
        }
        return result;
    }

    @Override
    public ASTNode visitForLockingClause(PostgreSQLStatementParser.ForLockingClauseContext ctx) {
        return new LockSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
    }

    @Override
    public ASTNode visitSelectWithParens(PostgreSQLStatementParser.SelectWithParensContext ctx) {
        if (null != ctx.selectWithParens()) {
            return (ASTNode)this.visit((ParseTree)ctx.selectWithParens());
        }
        return (ASTNode)this.visit((ParseTree)ctx.selectNoParens());
    }

    @Override
    public ASTNode visitSelectClauseN(PostgreSQLStatementParser.SelectClauseNContext ctx) {
        return null == ctx.simpleSelect() ? new PostgreSQLSelectStatement() : (ASTNode)this.visit((ParseTree)ctx.simpleSelect());
    }

    @Override
    public ASTNode visitSimpleSelect(PostgreSQLStatementParser.SimpleSelectContext ctx) {
        PostgreSQLSelectStatement result = new PostgreSQLSelectStatement();
        if (null != ctx.targetList()) {
            ProjectionsSegment projects = (ProjectionsSegment)this.visit((ParseTree)ctx.targetList());
            if (null != ctx.distinctClause()) {
                projects.setDistinctRow(true);
            }
            result.setProjections(projects);
        } else {
            result.setProjections(new ProjectionsSegment(-1, -1));
        }
        if (null != ctx.fromClause()) {
            TableSegment tableSegment = (TableSegment)this.visit((ParseTree)ctx.fromClause());
            result.setFrom(tableSegment);
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.groupClause()) {
            result.setGroupBy((GroupBySegment)this.visit((ParseTree)ctx.groupClause()));
        }
        if (null != ctx.havingClause()) {
            result.setHaving((HavingSegment)this.visit((ParseTree)ctx.havingClause()));
        }
        if (null != ctx.windowClause()) {
            result.setWindow((WindowSegment)this.visit((ParseTree)ctx.windowClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitHavingClause(PostgreSQLStatementParser.HavingClauseContext ctx) {
        ExpressionSegment expr = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr());
        return new HavingSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), expr);
    }

    @Override
    public ASTNode visitWindowClause(PostgreSQLStatementParser.WindowClauseContext ctx) {
        return new WindowSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
    }

    @Override
    public ASTNode visitGroupClause(PostgreSQLStatementParser.GroupClauseContext ctx) {
        LinkedList<OrderByItemSegment> items = new LinkedList<OrderByItemSegment>();
        for (PostgreSQLStatementParser.GroupByItemContext each : ctx.groupByList().groupByItem()) {
            items.add((OrderByItemSegment)this.visit((ParseTree)each));
        }
        return new GroupBySegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), items);
    }

    @Override
    public ASTNode visitGroupByItem(PostgreSQLStatementParser.GroupByItemContext ctx) {
        if (null != ctx.aExpr()) {
            ASTNode astNode = (ASTNode)this.visit((ParseTree)ctx.aExpr());
            if (astNode instanceof ColumnSegment) {
                return new ColumnOrderByItemSegment((ColumnSegment)astNode, OrderDirection.ASC);
            }
            if (astNode instanceof LiteralExpressionSegment) {
                LiteralExpressionSegment index = (LiteralExpressionSegment)astNode;
                return new IndexOrderByItemSegment(index.getStartIndex(), index.getStopIndex(), Integer.parseInt(index.getLiterals().toString()), OrderDirection.ASC);
            }
            return new ExpressionOrderByItemSegment(ctx.start.getStartIndex(), ctx.start.getStopIndex(), ctx.getText(), OrderDirection.ASC);
        }
        return new ExpressionOrderByItemSegment(ctx.start.getStartIndex(), ctx.start.getStopIndex(), ctx.getText(), OrderDirection.ASC);
    }

    @Override
    public ASTNode visitTargetList(PostgreSQLStatementParser.TargetListContext ctx) {
        ProjectionsSegment result = new ProjectionsSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        if (null != ctx.targetList()) {
            ProjectionsSegment projections = (ProjectionsSegment)this.visit((ParseTree)ctx.targetList());
            result.getProjections().addAll(projections.getProjections());
        }
        ProjectionSegment projection = (ProjectionSegment)this.visit((ParseTree)ctx.targetEl());
        result.getProjections().add(projection);
        return result;
    }

    @Override
    public ASTNode visitTargetEl(PostgreSQLStatementParser.TargetElContext ctx) {
        AliasSegment alias;
        ASTNode projection;
        if (null != ctx.ASTERISK_()) {
            return new ShorthandProjectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        }
        if (null != ctx.DOT_ASTERISK_()) {
            ShorthandProjectionSegment shorthandProjection = new ShorthandProjectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
            shorthandProjection.setOwner(new OwnerSegment(ctx.colId().start.getStartIndex(), ctx.colId().stop.getStopIndex(), new IdentifierValue(ctx.colId().getText())));
            return shorthandProjection;
        }
        PostgreSQLStatementParser.AExprContext expr = ctx.aExpr();
        if (1 == expr.getChildCount() && null != expr.cExpr()) {
            projection = (ASTNode)this.visit((ParseTree)expr.cExpr());
            AliasSegment aliasSegment = alias = null != ctx.identifier() ? new AliasSegment(ctx.identifier().start.getStartIndex(), ctx.identifier().stop.getStopIndex(), new IdentifierValue(ctx.identifier().getText())) : null;
            if (projection instanceof ColumnSegment) {
                ColumnProjectionSegment result = new ColumnProjectionSegment((ColumnSegment)projection);
                result.setAlias(alias);
                return result;
            }
        }
        if (null != expr.cExpr() && null != expr.cExpr().funcExpr()) {
            this.visit((ParseTree)expr.cExpr().funcExpr());
            projection = this.generateProjectFromFuncExpr(expr.cExpr().funcExpr());
            AliasSegment aliasSegment = alias = null != ctx.identifier() ? new AliasSegment(ctx.identifier().start.getStartIndex(), ctx.identifier().stop.getStopIndex(), new IdentifierValue(ctx.identifier().getText())) : null;
            if (projection instanceof AggregationProjectionSegment) {
                ((AggregationProjectionSegment)projection).setAlias(alias);
            }
            if (projection instanceof AggregationDistinctProjectionSegment) {
                ((AggregationDistinctProjectionSegment)projection).setAlias(alias);
            }
            return projection;
        }
        if (null != expr.cExpr() && null != expr.cExpr().selectWithParens()) {
            PostgreSQLSelectStatement select = (PostgreSQLSelectStatement)this.visit((ParseTree)expr.cExpr().selectWithParens());
            SubquerySegment subquery = new SubquerySegment(expr.cExpr().selectWithParens().start.getStartIndex(), expr.cExpr().selectWithParens().stop.getStopIndex(), (SelectStatement)select);
            String text = ctx.start.getInputStream().getText(new Interval(subquery.getStartIndex(), subquery.getStopIndex()));
            SubqueryProjectionSegment projection2 = new SubqueryProjectionSegment(subquery, text);
            AliasSegment alias2 = null != ctx.identifier() ? new AliasSegment(ctx.identifier().start.getStartIndex(), ctx.identifier().stop.getStopIndex(), new IdentifierValue(ctx.identifier().getText())) : null;
            projection2.setAlias(alias2);
            return projection2;
        }
        ExpressionProjectionSegment result = new ExpressionProjectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), expr.getText());
        if (null != ctx.identifier()) {
            alias = new AliasSegment(ctx.identifier().start.getStartIndex(), ctx.identifier().stop.getStopIndex(), new IdentifierValue(ctx.identifier().getText()));
            result.setAlias(alias);
        }
        return result;
    }

    @Override
    public ASTNode visitFromClause(PostgreSQLStatementParser.FromClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.fromList());
    }

    @Override
    public ASTNode visitFromList(PostgreSQLStatementParser.FromListContext ctx) {
        if (null != ctx.fromList()) {
            JoinTableSegment result = new JoinTableSegment();
            result.setStartIndex(ctx.start.getStartIndex());
            result.setStopIndex(ctx.stop.getStopIndex());
            result.setLeft((TableSegment)this.visit((ParseTree)ctx.fromList()));
            result.setRight((TableSegment)this.visit((ParseTree)ctx.tableReference()));
            return result;
        }
        return (ASTNode)this.visit((ParseTree)ctx.tableReference());
    }

    @Override
    public ASTNode visitTableReference(PostgreSQLStatementParser.TableReferenceContext ctx) {
        if (null != ctx.relationExpr()) {
            SimpleTableSegment result = this.generateTableFromRelationExpr(ctx.relationExpr());
            if (null != ctx.aliasClause()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.aliasClause()));
            }
            return result;
        }
        if (null != ctx.selectWithParens()) {
            PostgreSQLSelectStatement select = (PostgreSQLSelectStatement)this.visit((ParseTree)ctx.selectWithParens());
            SubquerySegment subquery = new SubquerySegment(ctx.selectWithParens().start.getStartIndex(), ctx.selectWithParens().stop.getStopIndex(), (SelectStatement)select);
            AliasSegment alias = null != ctx.aliasClause() ? (AliasSegment)this.visit((ParseTree)ctx.aliasClause()) : null;
            SubqueryTableSegment result = new SubqueryTableSegment(subquery);
            result.setAlias(alias);
            return result;
        }
        if (null != ctx.tableReference()) {
            JoinTableSegment result = new JoinTableSegment();
            result.setLeft((TableSegment)this.visit((ParseTree)ctx.tableReference()));
            int startIndex = null != ctx.LP_() ? ctx.LP_().getSymbol().getStartIndex() : ctx.tableReference().start.getStartIndex();
            int stopIndex = 0;
            AliasSegment alias = null;
            if (null != ctx.aliasClause()) {
                alias = (AliasSegment)this.visit((ParseTree)ctx.aliasClause());
                startIndex = null != ctx.RP_() ? ctx.RP_().getSymbol().getStopIndex() : ctx.joinedTable().stop.getStopIndex();
            } else {
                stopIndex = null != ctx.RP_() ? ctx.RP_().getSymbol().getStopIndex() : ctx.tableReference().start.getStopIndex();
            }
            result.setStartIndex(startIndex);
            result.setStopIndex(stopIndex);
            result = this.visitJoinedTable(ctx.joinedTable(), result);
            result.setAlias(alias);
            return result;
        }
        return new SimpleTableSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue("not support"));
    }

    private JoinTableSegment visitJoinedTable(PostgreSQLStatementParser.JoinedTableContext ctx, JoinTableSegment tableSegment) {
        JoinTableSegment result = tableSegment;
        TableSegment right = (TableSegment)this.visit((ParseTree)ctx.tableReference());
        result.setRight(right);
        if (null != ctx.joinQual()) {
            result = this.visitJoinQual(ctx.joinQual(), result);
        }
        return result;
    }

    private JoinTableSegment visitJoinQual(PostgreSQLStatementParser.JoinQualContext ctx, JoinTableSegment joinTableSource) {
        if (null != ctx.aExpr()) {
            ExpressionSegment condition = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr());
            joinTableSource.setCondition(condition);
        }
        if (null != ctx.USING()) {
            joinTableSource.setUsing(this.generateUsingColumn(ctx.nameList()));
        }
        return joinTableSource;
    }

    private List<ColumnSegment> generateUsingColumn(PostgreSQLStatementParser.NameListContext ctx) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        if (null != ctx.nameList()) {
            result.addAll(this.generateUsingColumn(ctx.nameList()));
        }
        if (null != ctx.name()) {
            ColumnSegment column = new ColumnSegment(ctx.name().start.getStartIndex(), ctx.name().stop.getStopIndex(), new IdentifierValue(ctx.name().getText()));
            result.add(column);
        }
        return result;
    }

    @Override
    public ASTNode visitAliasClause(PostgreSQLStatementParser.AliasClauseContext ctx) {
        StringBuilder aliasName = new StringBuilder(ctx.colId().getText());
        if (null != ctx.nameList()) {
            aliasName.append(ctx.LP_().getText());
            aliasName.append(ctx.nameList().getText());
            aliasName.append(ctx.RP_().getText());
        }
        return new AliasSegment(ctx.colId().start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(aliasName.toString()));
    }

    private SimpleTableSegment generateTableFromRelationExpr(PostgreSQLStatementParser.RelationExprContext ctx) {
        PostgreSQLStatementParser.QualifiedNameContext qualifiedName = ctx.qualifiedName();
        if (null != qualifiedName.indirection()) {
            PostgreSQLStatementParser.AttrNameContext tableName = qualifiedName.indirection().indirectionEl().attrName();
            SimpleTableSegment table = new SimpleTableSegment(tableName.start.getStartIndex(), tableName.stop.getStopIndex(), new IdentifierValue(tableName.getText()));
            table.setOwner(new OwnerSegment(qualifiedName.colId().start.getStartIndex(), qualifiedName.colId().stop.getStopIndex(), new IdentifierValue(qualifiedName.colId().getText())));
            return table;
        }
        return new SimpleTableSegment(qualifiedName.colId().start.getStartIndex(), qualifiedName.colId().stop.getStopIndex(), new IdentifierValue(qualifiedName.colId().getText()));
    }

    @Override
    public ASTNode visitWhereClause(PostgreSQLStatementParser.WhereClauseContext ctx) {
        ExpressionSegment expr = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr());
        return new WhereSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), expr);
    }

    @Override
    public ASTNode visitSelectLimit(PostgreSQLStatementParser.SelectLimitContext ctx) {
        if (null != ctx.limitClause() && null != ctx.offsetClause()) {
            return this.createLimitSegmentWhenLimitAndOffset(ctx);
        }
        return this.createLimitSegmentWhenRowCountOrOffsetAbsent(ctx);
    }

    @Override
    public ASTNode visitSelectLimitValue(PostgreSQLStatementParser.SelectLimitValueContext ctx) {
        if (null != ctx.ALL()) {
            return null;
        }
        ASTNode astNode = (ASTNode)this.visit((ParseTree)ctx.aExpr());
        if (astNode instanceof ParameterMarkerExpressionSegment) {
            return new ParameterMarkerLimitValueSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ((ParameterMarkerExpressionSegment)astNode).getParameterMarkerIndex());
        }
        return new NumberLiteralLimitValueSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), Long.parseLong(((LiteralExpressionSegment)astNode).getLiterals().toString()));
    }

    @Override
    public ASTNode visitSelectOffsetValue(PostgreSQLStatementParser.SelectOffsetValueContext ctx) {
        ASTNode astNode = (ASTNode)this.visit((ParseTree)ctx.aExpr());
        if (astNode instanceof ParameterMarkerExpressionSegment) {
            return new ParameterMarkerLimitValueSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ((ParameterMarkerExpressionSegment)astNode).getParameterMarkerIndex());
        }
        return new NumberLiteralLimitValueSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), Long.parseLong(((LiteralExpressionSegment)astNode).getLiterals().toString()));
    }

    private LimitSegment createLimitSegmentWhenLimitAndOffset(PostgreSQLStatementParser.SelectLimitContext ctx) {
        ParseTree astNode0 = ctx.getChild(0);
        LimitValueSegment rowCount = null;
        LimitValueSegment offset = null;
        if (astNode0 instanceof PostgreSQLStatementParser.LimitClauseContext) {
            rowCount = null == ctx.limitClause().selectLimitValue() ? null : (LimitValueSegment)this.visit((ParseTree)ctx.limitClause().selectLimitValue());
        } else {
            offset = (LimitValueSegment)this.visit((ParseTree)ctx.offsetClause().selectOffsetValue());
        }
        ParseTree astNode1 = ctx.getChild(1);
        if (astNode1 instanceof PostgreSQLStatementParser.LimitClauseContext) {
            rowCount = null == ctx.limitClause().selectLimitValue() ? null : (LimitValueSegment)this.visit((ParseTree)ctx.limitClause().selectLimitValue());
        } else {
            offset = (LimitValueSegment)this.visit((ParseTree)ctx.offsetClause().selectOffsetValue());
        }
        return new LimitSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (PaginationValueSegment)offset, (PaginationValueSegment)rowCount);
    }

    private LimitSegment createLimitSegmentWhenRowCountOrOffsetAbsent(PostgreSQLStatementParser.SelectLimitContext ctx) {
        if (null != ctx.limitClause()) {
            if (null != ctx.limitClause().selectOffsetValue()) {
                LimitValueSegment limit = (LimitValueSegment)this.visit((ParseTree)ctx.limitClause().selectLimitValue());
                LimitValueSegment offset = (LimitValueSegment)this.visit((ParseTree)ctx.limitClause().selectOffsetValue());
                return new LimitSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (PaginationValueSegment)offset, (PaginationValueSegment)limit);
            }
            LimitValueSegment limit = (LimitValueSegment)this.visit((ParseTree)ctx.limitClause().selectLimitValue());
            return new LimitSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), null, (PaginationValueSegment)limit);
        }
        LimitValueSegment offset = (LimitValueSegment)this.visit((ParseTree)ctx.offsetClause().selectOffsetValue());
        return new LimitSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (PaginationValueSegment)offset, null);
    }

    @Override
    public ASTNode visitExecuteStmt(PostgreSQLStatementParser.ExecuteStmtContext ctx) {
        return new PostgreSQLExecuteStatement();
    }

    @Generated
    public PostgreSQLStatementSQLVisitor() {
    }

    @Generated
    protected int getCurrentParameterIndex() {
        return this.currentParameterIndex;
    }
}

