/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql92.visitor.statement.impl;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.autogen.SQL92StatementBaseVisitor;
import org.apache.shardingsphere.sql.parser.autogen.SQL92StatementParser;
import org.apache.shardingsphere.sql.parser.sql.common.constant.AggregationType;
import org.apache.shardingsphere.sql.parser.sql.common.constant.OrderDirection;
import org.apache.shardingsphere.sql.parser.sql.common.constant.ParameterMarkerType;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.NotExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationDistinctProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DataTypeLengthSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.keyword.KeywordValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.BooleanLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.OtherLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.parametermarker.ParameterMarkerValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sql92.dml.SQL92SelectStatement;

public abstract class SQL92StatementSQLVisitor
extends SQL92StatementBaseVisitor<ASTNode> {
    private int currentParameterIndex;

    public SQL92StatementSQLVisitor(Properties props) {
    }

    @Override
    public final ASTNode visitParameterMarker(SQL92StatementParser.ParameterMarkerContext ctx) {
        return new ParameterMarkerValue(Integer.valueOf(this.currentParameterIndex++), ParameterMarkerType.QUESTION);
    }

    @Override
    public final ASTNode visitLiterals(SQL92StatementParser.LiteralsContext ctx) {
        if (null != ctx.stringLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.stringLiterals());
        }
        if (null != ctx.numberLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.numberLiterals());
        }
        if (null != ctx.hexadecimalLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.hexadecimalLiterals());
        }
        if (null != ctx.bitValueLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.bitValueLiterals());
        }
        if (null != ctx.booleanLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.booleanLiterals());
        }
        if (null != ctx.nullValueLiterals()) {
            return (ASTNode)this.visit((ParseTree)ctx.nullValueLiterals());
        }
        throw new IllegalStateException("Literals must have string, number, dateTime, hex, bit, boolean or null.");
    }

    @Override
    public final ASTNode visitStringLiterals(SQL92StatementParser.StringLiteralsContext ctx) {
        return new StringLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitNumberLiterals(SQL92StatementParser.NumberLiteralsContext ctx) {
        return new NumberLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitHexadecimalLiterals(SQL92StatementParser.HexadecimalLiteralsContext ctx) {
        return new OtherLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitBitValueLiterals(SQL92StatementParser.BitValueLiteralsContext ctx) {
        return new OtherLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitBooleanLiterals(SQL92StatementParser.BooleanLiteralsContext ctx) {
        return new BooleanLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitNullValueLiterals(SQL92StatementParser.NullValueLiteralsContext ctx) {
        return new OtherLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitIdentifier(SQL92StatementParser.IdentifierContext ctx) {
        SQL92StatementParser.UnreservedWordContext unreservedWord = ctx.unreservedWord();
        return null != unreservedWord ? (ASTNode)this.visit((ParseTree)unreservedWord) : new IdentifierValue(ctx.getText());
    }

    @Override
    public final ASTNode visitUnreservedWord(SQL92StatementParser.UnreservedWordContext ctx) {
        return new IdentifierValue(ctx.getText());
    }

    @Override
    public final ASTNode visitSchemaName(SQL92StatementParser.SchemaNameContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.identifier());
    }

    @Override
    public final ASTNode visitTableName(SQL92StatementParser.TableNameContext ctx) {
        SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ctx.name().getStart().getStartIndex(), ctx.name().getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name())));
        SQL92StatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        return result;
    }

    @Override
    public final ASTNode visitColumnName(SQL92StatementParser.ColumnNameContext ctx) {
        ColumnSegment result = new ColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name()));
        SQL92StatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        return result;
    }

    @Override
    public final ASTNode visitTableNames(SQL92StatementParser.TableNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (SQL92StatementParser.TableNameContext each : ctx.tableName()) {
            result.getValue().add((SimpleTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitColumnNames(SQL92StatementParser.ColumnNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (SQL92StatementParser.ColumnNameContext each : ctx.columnName()) {
            result.getValue().add((ColumnSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitExpr(SQL92StatementParser.ExprContext ctx) {
        if (null != ctx.booleanPrimary()) {
            return (ASTNode)this.visit((ParseTree)ctx.booleanPrimary());
        }
        if (null != ctx.LP_()) {
            return (ASTNode)this.visit((ParseTree)ctx.expr(0));
        }
        if (null != ctx.andOperator()) {
            return this.createBinaryOperationExpression(ctx, ctx.andOperator().getText());
        }
        if (null != ctx.orOperator()) {
            return this.createBinaryOperationExpression(ctx, ctx.orOperator().getText());
        }
        return new NotExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (ExpressionSegment)this.visit((ParseTree)ctx.expr(0)));
    }

    private ASTNode createBinaryOperationExpression(SQL92StatementParser.ExprContext ctx, String operator) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.expr(0));
        ExpressionSegment right = (ExpressionSegment)this.visit((ParseTree)ctx.expr(1));
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    @Override
    public final ASTNode visitBooleanPrimary(SQL92StatementParser.BooleanPrimaryContext ctx) {
        if (null != ctx.IS()) {
            ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.booleanPrimary());
            LiteralExpressionSegment right = new LiteralExpressionSegment(ctx.IS().getSymbol().getStopIndex() + 1, ctx.stop.getStopIndex(), (Object)new Interval(ctx.IS().getSymbol().getStopIndex() + 1, ctx.stop.getStopIndex()));
            String operator = "IS";
            String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
            return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, (ExpressionSegment)right, operator, text);
        }
        if (null != ctx.comparisonOperator() || null != ctx.SAFE_EQ_()) {
            return this.createCompareSegment(ctx);
        }
        return (ASTNode)this.visit((ParseTree)ctx.predicate());
    }

    private ASTNode createCompareSegment(SQL92StatementParser.BooleanPrimaryContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.booleanPrimary());
        ExpressionSegment right = null != ctx.predicate() ? (ExpressionSegment)this.visit((ParseTree)ctx.predicate()) : (ExpressionSegment)this.visit((ParseTree)ctx.subquery());
        String operator = null != ctx.SAFE_EQ_() ? ctx.SAFE_EQ_().getText() : ctx.comparisonOperator().getText();
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    @Override
    public final ASTNode visitPredicate(SQL92StatementParser.PredicateContext ctx) {
        if (null != ctx.IN()) {
            return this.createInSegment(ctx);
        }
        if (null != ctx.BETWEEN()) {
            return this.createBetweenSegment(ctx);
        }
        if (null != ctx.LIKE()) {
            return this.createBinaryOperationExpressionFromLike(ctx);
        }
        return (ASTNode)this.visit((ParseTree)ctx.bitExpr(0));
    }

    private BinaryOperationExpression createBinaryOperationExpressionFromLike(SQL92StatementParser.PredicateContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(0));
        ListExpression right = new ListExpression(ctx.simpleExpr((int)0).start.getStartIndex(), ctx.simpleExpr().get((int)(ctx.simpleExpr().size() - 1)).stop.getStopIndex());
        for (SQL92StatementParser.SimpleExprContext each : ctx.simpleExpr()) {
            right.getItems().add((ExpressionSegment)this.visit((ParseTree)each));
        }
        String operator = null != ctx.NOT() ? "NOT LIKE" : "LIKE";
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, (ExpressionSegment)right, operator, text);
    }

    private InExpression createInSegment(SQL92StatementParser.PredicateContext ctx) {
        SubqueryExpressionSegment right;
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(0));
        if (null != ctx.subquery()) {
            right = new SubqueryExpressionSegment(new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), (SelectStatement)((SQL92SelectStatement)this.visit((ParseTree)ctx.subquery()))));
        } else {
            ListExpression listExpression = new ListExpression(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex());
            for (SQL92StatementParser.ExprContext each : ctx.expr()) {
                listExpression.getItems().add((ExpressionSegment)this.visit((ParseTree)each));
            }
            right = listExpression;
        }
        boolean not = null != ctx.NOT();
        return new InExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, (ExpressionSegment)right, not);
    }

    private BetweenExpression createBetweenSegment(SQL92StatementParser.PredicateContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(0));
        ExpressionSegment between = (ExpressionSegment)this.visit((ParseTree)ctx.bitExpr(1));
        ExpressionSegment and = (ExpressionSegment)this.visit((ParseTree)ctx.predicate());
        boolean not = null != ctx.NOT();
        return new BetweenExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, between, and, not);
    }

    @Override
    public final ASTNode visitBitExpr(SQL92StatementParser.BitExprContext ctx) {
        if (null != ctx.simpleExpr()) {
            return this.createExpressionSegment((ASTNode)this.visit((ParseTree)ctx.simpleExpr()), ctx);
        }
        ExpressionSegment left = (ExpressionSegment)this.visit(ctx.getChild(0));
        ExpressionSegment right = (ExpressionSegment)this.visit(ctx.getChild(2));
        String operator = ctx.getChild(1).getText();
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    private ASTNode createExpressionSegment(ASTNode astNode, ParserRuleContext context) {
        if (astNode instanceof StringLiteralValue) {
            return new LiteralExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), (Object)((StringLiteralValue)astNode).getValue());
        }
        if (astNode instanceof NumberLiteralValue) {
            return new LiteralExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), (Object)((NumberLiteralValue)astNode).getValue());
        }
        if (astNode instanceof BooleanLiteralValue) {
            return new LiteralExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), (Object)((BooleanLiteralValue)astNode).getValue());
        }
        if (astNode instanceof ParameterMarkerValue) {
            ParameterMarkerValue parameterMarker = (ParameterMarkerValue)astNode;
            return new ParameterMarkerExpressionSegment(context.start.getStartIndex(), context.stop.getStopIndex(), parameterMarker.getValue().intValue(), parameterMarker.getType());
        }
        if (astNode instanceof SubquerySegment) {
            return new SubqueryExpressionSegment((SubquerySegment)astNode);
        }
        if (astNode instanceof OtherLiteralValue) {
            return new CommonExpressionSegment(context.getStart().getStartIndex(), context.getStop().getStopIndex(), ((OtherLiteralValue)astNode).getValue());
        }
        return astNode;
    }

    @Override
    public final ASTNode visitSimpleExpr(SQL92StatementParser.SimpleExprContext ctx) {
        int startIndex = ctx.getStart().getStartIndex();
        int stopIndex = ctx.getStop().getStopIndex();
        if (null != ctx.subquery()) {
            return new SubquerySegment(startIndex, stopIndex, (SelectStatement)((SQL92SelectStatement)this.visit((ParseTree)ctx.subquery())));
        }
        if (null != ctx.parameterMarker()) {
            ParameterMarkerValue parameterMarker = (ParameterMarkerValue)this.visit((ParseTree)ctx.parameterMarker());
            return new ParameterMarkerExpressionSegment(startIndex, stopIndex, parameterMarker.getValue().intValue(), parameterMarker.getType());
        }
        if (null != ctx.literals()) {
            return SQLUtil.createLiteralExpression((ASTNode)((ASTNode)this.visit((ParseTree)ctx.literals())), (int)startIndex, (int)stopIndex, (String)ctx.literals().start.getInputStream().getText(new Interval(startIndex, stopIndex)));
        }
        if (null != ctx.functionCall()) {
            return (ASTNode)this.visit((ParseTree)ctx.functionCall());
        }
        if (null != ctx.columnName()) {
            return (ASTNode)this.visit((ParseTree)ctx.columnName());
        }
        return new CommonExpressionSegment(startIndex, stopIndex, ctx.getText());
    }

    @Override
    public final ASTNode visitIntervalExpression(SQL92StatementParser.IntervalExpressionContext ctx) {
        this.calculateParameterCount(Collections.singleton(ctx.expr()));
        return new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), this.getOriginalText(ctx));
    }

    @Override
    public final ASTNode visitFunctionCall(SQL92StatementParser.FunctionCallContext ctx) {
        if (null != ctx.aggregationFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.aggregationFunction());
        }
        if (null != ctx.specialFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.specialFunction());
        }
        if (null != ctx.regularFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.regularFunction());
        }
        throw new IllegalStateException("FunctionCallContext must have aggregationFunction, regularFunction or specialFunction.");
    }

    @Override
    public final ASTNode visitAggregationFunction(SQL92StatementParser.AggregationFunctionContext ctx) {
        String aggregationType = ctx.aggregationFunctionName().getText();
        return AggregationType.isAggregationType((String)aggregationType) ? this.createAggregationSegment(ctx, aggregationType) : new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), this.getOriginalText(ctx));
    }

    private ASTNode createAggregationSegment(SQL92StatementParser.AggregationFunctionContext ctx, String aggregationType) {
        AggregationType type = AggregationType.valueOf((String)aggregationType.toUpperCase());
        String innerExpression = ctx.start.getInputStream().getText(new Interval(ctx.LP_().getSymbol().getStartIndex(), ctx.stop.getStopIndex()));
        if (null == ctx.distinct()) {
            return new AggregationProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, innerExpression);
        }
        return new AggregationDistinctProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, innerExpression, this.getDistinctExpression(ctx));
    }

    private String getDistinctExpression(SQL92StatementParser.AggregationFunctionContext ctx) {
        StringBuilder result = new StringBuilder();
        for (int i = 3; i < ctx.getChildCount() - 1; ++i) {
            result.append(ctx.getChild(i).getText());
        }
        return result.toString();
    }

    @Override
    public final ASTNode visitSpecialFunction(SQL92StatementParser.SpecialFunctionContext ctx) {
        if (null != ctx.castFunction()) {
            return (ASTNode)this.visit((ParseTree)ctx.castFunction());
        }
        return new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getChild(0).getChild(0).getText(), this.getOriginalText(ctx));
    }

    @Override
    public final ASTNode visitCastFunction(SQL92StatementParser.CastFunctionContext ctx) {
        this.calculateParameterCount(Collections.singleton(ctx.expr()));
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.CAST().getText(), this.getOriginalText(ctx));
        ASTNode exprSegment = (ASTNode)this.visit((ParseTree)ctx.expr());
        if (exprSegment instanceof ColumnSegment) {
            result.getParameters().add((ColumnSegment)exprSegment);
        } else if (exprSegment instanceof LiteralExpressionSegment) {
            result.getParameters().add((LiteralExpressionSegment)exprSegment);
        }
        result.getParameters().add((DataTypeSegment)this.visit((ParseTree)ctx.dataType()));
        return result;
    }

    @Override
    public final ASTNode visitRegularFunction(SQL92StatementParser.RegularFunctionContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.regularFunctionName().getText(), this.getOriginalText(ctx));
        Collection expressionSegments = ctx.expr().stream().map(each -> (ExpressionSegment)this.visit((ParseTree)each)).collect(Collectors.toList());
        result.getParameters().addAll(expressionSegments);
        return result;
    }

    @Override
    public final ASTNode visitDataTypeName(SQL92StatementParser.DataTypeNameContext ctx) {
        LinkedList<String> dataTypeNames = new LinkedList<String>();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            dataTypeNames.add(ctx.getChild(i).getText());
        }
        return new KeywordValue(Joiner.on((String)" ").join(dataTypeNames));
    }

    private void calculateParameterCount(Collection<SQL92StatementParser.ExprContext> exprContexts) {
        for (SQL92StatementParser.ExprContext each : exprContexts) {
            this.visit((ParseTree)each);
        }
    }

    @Override
    public final ASTNode visitOrderByClause(SQL92StatementParser.OrderByClauseContext ctx) {
        LinkedList<OrderByItemSegment> items = new LinkedList<OrderByItemSegment>();
        for (SQL92StatementParser.OrderByItemContext each : ctx.orderByItem()) {
            items.add((OrderByItemSegment)this.visit((ParseTree)each));
        }
        return new OrderBySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), items);
    }

    @Override
    public final ASTNode visitOrderByItem(SQL92StatementParser.OrderByItemContext ctx) {
        OrderDirection orderDirection;
        OrderDirection orderDirection2 = orderDirection = null != ctx.DESC() ? OrderDirection.DESC : OrderDirection.ASC;
        if (null != ctx.columnName()) {
            ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
            return new ColumnOrderByItemSegment(column, orderDirection);
        }
        return new IndexOrderByItemSegment(ctx.numberLiterals().getStart().getStartIndex(), ctx.numberLiterals().getStop().getStopIndex(), SQLUtil.getExactlyNumber((String)ctx.numberLiterals().getText(), (int)10).intValue(), orderDirection);
    }

    @Override
    public final ASTNode visitDataType(SQL92StatementParser.DataTypeContext ctx) {
        DataTypeSegment result = new DataTypeSegment();
        result.setDataTypeName(((KeywordValue)this.visit((ParseTree)ctx.dataTypeName())).getValue());
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        if (null != ctx.dataTypeLength()) {
            DataTypeLengthSegment dataTypeLengthSegment = (DataTypeLengthSegment)this.visit((ParseTree)ctx.dataTypeLength());
            result.setDataLength(dataTypeLengthSegment);
        }
        return result;
    }

    @Override
    public final ASTNode visitDataTypeLength(SQL92StatementParser.DataTypeLengthContext ctx) {
        DataTypeLengthSegment result = new DataTypeLengthSegment();
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStartIndex());
        List<TerminalNode> numbers = ctx.NUMBER_();
        if (numbers.size() == 1) {
            result.setPrecision(Integer.parseInt(numbers.get(0).getText()));
        }
        if (numbers.size() == 2) {
            result.setPrecision(Integer.parseInt(numbers.get(0).getText()));
            result.setScale(Integer.parseInt(numbers.get(1).getText()));
        }
        return result;
    }

    protected String getOriginalText(ParserRuleContext ctx) {
        return ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    @Generated
    public SQL92StatementSQLVisitor() {
    }

    @Generated
    protected int getCurrentParameterIndex() {
        return this.currentParameterIndex;
    }
}

