/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.statement.dml;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.TableReferenceSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.LockSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.DMLStatement;

public final class SelectStatement
extends DMLStatement {
    private ProjectionsSegment projections;
    private final Collection<TableReferenceSegment> tableReferences = new LinkedList<TableReferenceSegment>();
    private WhereSegment where;
    private GroupBySegment groupBy;
    private OrderBySegment orderBy;
    private LimitSegment limit;
    private SelectStatement parentStatement;
    private LockSegment lock;

    public Optional<WhereSegment> getWhere() {
        return Optional.ofNullable(this.where);
    }

    public Optional<GroupBySegment> getGroupBy() {
        return Optional.ofNullable(this.groupBy);
    }

    public Optional<OrderBySegment> getOrderBy() {
        return Optional.ofNullable(this.orderBy);
    }

    public Optional<LimitSegment> getLimit() {
        return Optional.ofNullable(this.limit);
    }

    public Optional<LockSegment> getLock() {
        return Optional.ofNullable(this.lock);
    }

    public Collection<SimpleTableSegment> getSimpleTableSegments() {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (TableReferenceSegment each : this.tableReferences) {
            result.addAll(each.getTables());
        }
        return result;
    }

    @Generated
    public ProjectionsSegment getProjections() {
        return this.projections;
    }

    @Generated
    public Collection<TableReferenceSegment> getTableReferences() {
        return this.tableReferences;
    }

    @Generated
    public SelectStatement getParentStatement() {
        return this.parentStatement;
    }

    @Generated
    public void setProjections(ProjectionsSegment projections) {
        this.projections = projections;
    }

    @Generated
    public void setWhere(WhereSegment where) {
        this.where = where;
    }

    @Generated
    public void setGroupBy(GroupBySegment groupBy) {
        this.groupBy = groupBy;
    }

    @Generated
    public void setOrderBy(OrderBySegment orderBy) {
        this.orderBy = orderBy;
    }

    @Generated
    public void setLimit(LimitSegment limit) {
        this.limit = limit;
    }

    @Generated
    public void setParentStatement(SelectStatement parentStatement) {
        this.parentStatement = parentStatement;
    }

    @Generated
    public void setLock(LockSegment lock) {
        this.lock = lock;
    }
}

