/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public final class SafeNumberOperationUtils {
    public static Range<Comparable<?>> safeIntersection(Range<Comparable<?>> range, Range<Comparable<?>> connectedRange) {
        try {
            return range.intersection(connectedRange);
        }
        catch (ClassCastException ex) {
            Comparable rangeLowerEndpoint = range.hasLowerBound() ? range.lowerEndpoint() : null;
            Comparable rangeUpperEndpoint = range.hasUpperBound() ? range.upperEndpoint() : null;
            Comparable connectedRangeLowerEndpoint = connectedRange.hasLowerBound() ? connectedRange.lowerEndpoint() : null;
            Comparable connectedRangeUpperEndpoint = connectedRange.hasUpperBound() ? connectedRange.upperEndpoint() : null;
            Class<?> clazz = SafeNumberOperationUtils.getTargetNumericType(Lists.newArrayList((Object[])new Comparable[]{rangeLowerEndpoint, rangeUpperEndpoint, connectedRangeLowerEndpoint, connectedRangeUpperEndpoint}));
            if (clazz == null) {
                throw ex;
            }
            Range<Comparable<?>> newRange = SafeNumberOperationUtils.createTargetNumericTypeRange(range, clazz);
            Range<Comparable<?>> newConnectedRange = SafeNumberOperationUtils.createTargetNumericTypeRange(connectedRange, clazz);
            return newRange.intersection(newConnectedRange);
        }
    }

    public static Range<Comparable<?>> safeClosed(Comparable<?> lowerEndpoint, Comparable<?> upperEndpoint) {
        try {
            return Range.closed(lowerEndpoint, upperEndpoint);
        }
        catch (ClassCastException ex) {
            Class<?> clazz = SafeNumberOperationUtils.getTargetNumericType(Lists.newArrayList((Object[])new Comparable[]{lowerEndpoint, upperEndpoint}));
            if (clazz == null) {
                throw ex;
            }
            return Range.closed(SafeNumberOperationUtils.parseNumberByClazz(lowerEndpoint.toString(), clazz), SafeNumberOperationUtils.parseNumberByClazz(upperEndpoint.toString(), clazz));
        }
    }

    public static boolean safeContains(Range<Comparable<?>> range, Comparable<?> endpoint) {
        try {
            return range.contains(endpoint);
        }
        catch (ClassCastException ex) {
            Comparable rangeUpperEndpoint = range.hasUpperBound() ? range.upperEndpoint() : null;
            Comparable rangeLowerEndpoint = range.hasLowerBound() ? range.lowerEndpoint() : null;
            Class<?> clazz = SafeNumberOperationUtils.getTargetNumericType(Lists.newArrayList((Object[])new Comparable[]{rangeLowerEndpoint, rangeUpperEndpoint, endpoint}));
            if (clazz == null) {
                throw ex;
            }
            Range<Comparable<?>> newRange = SafeNumberOperationUtils.createTargetNumericTypeRange(range, clazz);
            return newRange.contains(SafeNumberOperationUtils.parseNumberByClazz(endpoint.toString(), clazz));
        }
    }

    public static boolean safeEquals(Collection<Comparable<?>> sourceCollection, Collection<Comparable<?>> targetCollection) {
        ArrayList collection = Lists.newArrayList(sourceCollection);
        collection.addAll(targetCollection);
        Class<?> clazz = SafeNumberOperationUtils.getTargetNumericType(collection);
        if (null == clazz) {
            return sourceCollection.equals(targetCollection);
        }
        List sourceClazzCollection = sourceCollection.stream().map(number -> SafeNumberOperationUtils.parseNumberByClazz(number.toString(), clazz)).collect(Collectors.toList());
        List targetClazzCollection = targetCollection.stream().map(number -> SafeNumberOperationUtils.parseNumberByClazz(number.toString(), clazz)).collect(Collectors.toList());
        return sourceClazzCollection.equals(targetClazzCollection);
    }

    private static Range<Comparable<?>> createTargetNumericTypeRange(Range<Comparable<?>> range, Class<?> clazz) {
        if (range.hasLowerBound() && range.hasUpperBound()) {
            Comparable<?> lowerEndpoint = SafeNumberOperationUtils.parseNumberByClazz(range.lowerEndpoint().toString(), clazz);
            Comparable<?> upperEndpoint = SafeNumberOperationUtils.parseNumberByClazz(range.upperEndpoint().toString(), clazz);
            return Range.range(lowerEndpoint, (BoundType)range.lowerBoundType(), upperEndpoint, (BoundType)range.upperBoundType());
        }
        if (!range.hasLowerBound() && !range.hasUpperBound()) {
            return Range.all();
        }
        if (range.hasLowerBound()) {
            Comparable<?> lowerEndpoint = SafeNumberOperationUtils.parseNumberByClazz(range.lowerEndpoint().toString(), clazz);
            return Range.downTo(lowerEndpoint, (BoundType)range.lowerBoundType());
        }
        Comparable<?> upperEndpoint = SafeNumberOperationUtils.parseNumberByClazz(range.upperEndpoint().toString(), clazz);
        return Range.upTo(upperEndpoint, (BoundType)range.upperBoundType());
    }

    private static Class<?> getTargetNumericType(List<Comparable<?>> endpoints) {
        Preconditions.checkNotNull(endpoints, (Object)"getTargetNumericType param endpoints can not be null.");
        Set clazzSet = endpoints.stream().filter(Objects::nonNull).map(Object::getClass).collect(Collectors.toSet());
        if (clazzSet.contains(BigDecimal.class)) {
            return BigDecimal.class;
        }
        if (clazzSet.contains(Double.class)) {
            return Double.class;
        }
        if (clazzSet.contains(Float.class)) {
            return Float.class;
        }
        if (clazzSet.contains(BigInteger.class)) {
            return BigInteger.class;
        }
        if (clazzSet.contains(Long.class)) {
            return Long.class;
        }
        if (clazzSet.contains(Integer.class)) {
            return Integer.class;
        }
        return null;
    }

    private static Comparable<?> parseNumberByClazz(String number, Class<?> clazz) {
        return (Comparable)clazz.getConstructor(String.class).newInstance(number);
    }

    @Generated
    private SafeNumberOperationUtils() {
    }
}

