/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class WhereSegmentExtractUtils {
    public static Collection<WhereSegment> getSubqueryWhereSegments(SelectStatement selectStatement) {
        LinkedList<WhereSegment> result = new LinkedList<WhereSegment>();
        result.addAll(WhereSegmentExtractUtils.getSubqueryWhereSegmentsFromProjections(selectStatement.getProjections()));
        result.addAll(WhereSegmentExtractUtils.getSubqueryWhereSegmentsFromTableSegment(selectStatement.getFrom()));
        if (selectStatement.getWhere().isPresent()) {
            result.addAll(WhereSegmentExtractUtils.getSubqueryWhereSegmentsFromExpression(selectStatement.getWhere().get().getExpr()));
        }
        return result;
    }

    private static Collection<WhereSegment> getSubqueryWhereSegmentsFromProjections(ProjectionsSegment projections) {
        if (null == projections || projections.getProjections().isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<WhereSegment> result = new LinkedList<WhereSegment>();
        for (ProjectionSegment each : projections.getProjections()) {
            if (!(each instanceof SubqueryProjectionSegment)) continue;
            SelectStatement subquerySelect = ((SubqueryProjectionSegment)each).getSubquery().getSelect();
            result.addAll(WhereSegmentExtractUtils.getSubqueryWhereSegmentsFromSubquery(subquerySelect));
        }
        return result;
    }

    private static Collection<WhereSegment> getSubqueryWhereSegmentsFromSubquery(SelectStatement subquerySelect) {
        LinkedList<WhereSegment> result = new LinkedList<WhereSegment>();
        subquerySelect.getWhere().ifPresent(result::add);
        result.addAll(WhereSegmentExtractUtils.getSubqueryWhereSegments(subquerySelect));
        return result;
    }

    private static Collection<WhereSegment> getSubqueryWhereSegmentsFromTableSegment(TableSegment tableSegment) {
        if (null == tableSegment) {
            return Collections.emptyList();
        }
        LinkedList<WhereSegment> result = new LinkedList<WhereSegment>();
        if (tableSegment instanceof SubqueryTableSegment) {
            SelectStatement subquerySelect = ((SubqueryTableSegment)tableSegment).getSubquery().getSelect();
            result.addAll(WhereSegmentExtractUtils.getSubqueryWhereSegmentsFromSubquery(subquerySelect));
        }
        if (tableSegment instanceof JoinTableSegment) {
            result.addAll(WhereSegmentExtractUtils.getSubqueryWhereSegmentsFromTableSegment(((JoinTableSegment)tableSegment).getLeft()));
            result.addAll(WhereSegmentExtractUtils.getSubqueryWhereSegmentsFromTableSegment(((JoinTableSegment)tableSegment).getRight()));
        }
        return result;
    }

    private static Collection<WhereSegment> getSubqueryWhereSegmentsFromExpression(ExpressionSegment expressionSegment) {
        LinkedList<WhereSegment> result = new LinkedList<WhereSegment>();
        if (expressionSegment instanceof SubqueryExpressionSegment) {
            result.addAll(WhereSegmentExtractUtils.getSubqueryWhereSegmentsFromSubquery(((SubqueryExpressionSegment)expressionSegment).getSubquery().getSelect()));
        }
        if (expressionSegment instanceof ListExpression) {
            for (ExpressionSegment each : ((ListExpression)expressionSegment).getItems()) {
                result.addAll(WhereSegmentExtractUtils.getSubqueryWhereSegmentsFromExpression(each));
            }
        }
        if (expressionSegment instanceof BinaryOperationExpression) {
            result.addAll(WhereSegmentExtractUtils.getSubqueryWhereSegmentsFromExpression(((BinaryOperationExpression)expressionSegment).getLeft()));
            result.addAll(WhereSegmentExtractUtils.getSubqueryWhereSegmentsFromExpression(((BinaryOperationExpression)expressionSegment).getRight()));
        }
        return result;
    }

    @Generated
    private WhereSegmentExtractUtils() {
    }
}

