/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.util;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public final class SafeNumberOperationUtil {
    public static Range<Comparable<?>> safeIntersection(Range<Comparable<?>> range, Range<Comparable<?>> connectedRange) {
        try {
            return range.intersection(connectedRange);
        }
        catch (ClassCastException ex) {
            Class<?> clazz = SafeNumberOperationUtil.getRangeTargetNumericType(range, connectedRange);
            if (null == clazz) {
                throw ex;
            }
            Range<Comparable<?>> newRange = SafeNumberOperationUtil.createTargetNumericTypeRange(range, clazz);
            Range<Comparable<?>> newConnectedRange = SafeNumberOperationUtil.createTargetNumericTypeRange(connectedRange, clazz);
            return newRange.intersection(newConnectedRange);
        }
    }

    public static Range<Comparable<?>> safeClosed(Comparable<?> lowerEndpoint, Comparable<?> upperEndpoint) {
        try {
            return Range.closed(lowerEndpoint, upperEndpoint);
        }
        catch (ClassCastException ex) {
            Optional<Class<?>> clazz = SafeNumberOperationUtil.getTargetNumericType(Arrays.asList(lowerEndpoint, upperEndpoint));
            if (!clazz.isPresent()) {
                throw ex;
            }
            return Range.closed(SafeNumberOperationUtil.parseNumberByClazz(lowerEndpoint.toString(), clazz.get()), SafeNumberOperationUtil.parseNumberByClazz(upperEndpoint.toString(), clazz.get()));
        }
    }

    public static boolean safeContains(Range<Comparable<?>> range, Comparable<?> endpoint) {
        try {
            return range.contains(endpoint);
        }
        catch (ClassCastException ex) {
            Comparable rangeUpperEndpoint = range.hasUpperBound() ? range.upperEndpoint() : null;
            Comparable rangeLowerEndpoint = range.hasLowerBound() ? range.lowerEndpoint() : null;
            Optional<Class<?>> clazz = SafeNumberOperationUtil.getTargetNumericType(Arrays.asList(rangeLowerEndpoint, rangeUpperEndpoint, endpoint));
            if (!clazz.isPresent()) {
                throw ex;
            }
            Range<Comparable<?>> newRange = SafeNumberOperationUtil.createTargetNumericTypeRange(range, clazz.get());
            return newRange.contains(SafeNumberOperationUtil.parseNumberByClazz(endpoint.toString(), clazz.get()));
        }
    }

    public static boolean safeRangeEquals(Range<Comparable<?>> sourceRange, Range<Comparable<?>> targetRange) {
        Class<?> clazz = SafeNumberOperationUtil.getRangeTargetNumericType(sourceRange, targetRange);
        if (null == clazz) {
            return sourceRange.equals(targetRange);
        }
        Range<Comparable<?>> newSourceRange = SafeNumberOperationUtil.createTargetNumericTypeRange(sourceRange, clazz);
        Range<Comparable<?>> newTargetRange = SafeNumberOperationUtil.createTargetNumericTypeRange(targetRange, clazz);
        return newSourceRange.equals(newTargetRange);
    }

    public static boolean safeCollectionEquals(Collection<Comparable<?>> sources, Collection<Comparable<?>> targets) {
        ArrayList all = new ArrayList(sources);
        all.addAll(targets);
        Optional<Class<?>> clazz = SafeNumberOperationUtil.getTargetNumericType(all);
        if (!clazz.isPresent()) {
            return sources.equals(targets);
        }
        List sourceClasses = sources.stream().map(each -> SafeNumberOperationUtil.parseNumberByClazz(each.toString(), (Class)clazz.get())).collect(Collectors.toList());
        List targetClasses = targets.stream().map(each -> SafeNumberOperationUtil.parseNumberByClazz(each.toString(), (Class)clazz.get())).collect(Collectors.toList());
        return sourceClasses.equals(targetClasses);
    }

    private static Class<?> getRangeTargetNumericType(Range<Comparable<?>> sourceRange, Range<Comparable<?>> targetRange) {
        Comparable sourceRangeLowerEndpoint = sourceRange.hasLowerBound() ? sourceRange.lowerEndpoint() : null;
        Comparable sourceRangeUpperEndpoint = sourceRange.hasUpperBound() ? sourceRange.upperEndpoint() : null;
        Comparable targetRangeLowerEndpoint = targetRange.hasLowerBound() ? targetRange.lowerEndpoint() : null;
        Comparable targetRangeUpperEndpoint = targetRange.hasUpperBound() ? targetRange.upperEndpoint() : null;
        return SafeNumberOperationUtil.getTargetNumericType(Arrays.asList(sourceRangeLowerEndpoint, sourceRangeUpperEndpoint, targetRangeLowerEndpoint, targetRangeUpperEndpoint)).orElse(null);
    }

    private static Range<Comparable<?>> createTargetNumericTypeRange(Range<Comparable<?>> range, Class<?> clazz) {
        if (range.hasLowerBound() && range.hasUpperBound()) {
            Comparable<?> lowerEndpoint = SafeNumberOperationUtil.parseNumberByClazz(range.lowerEndpoint().toString(), clazz);
            Comparable<?> upperEndpoint = SafeNumberOperationUtil.parseNumberByClazz(range.upperEndpoint().toString(), clazz);
            return Range.range(lowerEndpoint, (BoundType)range.lowerBoundType(), upperEndpoint, (BoundType)range.upperBoundType());
        }
        if (!range.hasLowerBound() && !range.hasUpperBound()) {
            return Range.all();
        }
        if (range.hasLowerBound()) {
            Comparable<?> lowerEndpoint = SafeNumberOperationUtil.parseNumberByClazz(range.lowerEndpoint().toString(), clazz);
            return Range.downTo(lowerEndpoint, (BoundType)range.lowerBoundType());
        }
        Comparable<?> upperEndpoint = SafeNumberOperationUtil.parseNumberByClazz(range.upperEndpoint().toString(), clazz);
        return Range.upTo(upperEndpoint, (BoundType)range.upperBoundType());
    }

    private static Optional<Class<?>> getTargetNumericType(List<Comparable<?>> endpoints) {
        Set classes = endpoints.stream().filter(Objects::nonNull).map(Object::getClass).collect(Collectors.toSet());
        Class clazz = null;
        if (classes.contains(BigDecimal.class)) {
            clazz = BigDecimal.class;
        } else if (classes.contains(Double.class)) {
            clazz = Double.class;
        } else if (classes.contains(Float.class)) {
            clazz = Float.class;
        } else if (classes.contains(BigInteger.class)) {
            clazz = BigInteger.class;
        } else if (classes.contains(Long.class)) {
            clazz = Long.class;
        } else if (classes.contains(Integer.class)) {
            clazz = Integer.class;
        }
        return Optional.ofNullable(clazz);
    }

    private static Comparable<?> parseNumberByClazz(String number, Class<?> clazz) {
        return (Comparable)clazz.getConstructor(String.class).newInstance(number);
    }

    @Generated
    private SafeNumberOperationUtil() {
    }
}

