/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.traffic.distsql.handler.convert;

import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.distsql.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.traffic.api.config.TrafficRuleConfiguration;
import org.apache.shardingsphere.traffic.api.config.TrafficStrategyConfiguration;
import org.apache.shardingsphere.traffic.distsql.segment.TrafficRuleSegment;

public final class TrafficRuleConverter {
    public static TrafficRuleConfiguration convert(Collection<TrafficRuleSegment> segments) {
        TrafficRuleConfiguration result = new TrafficRuleConfiguration();
        for (TrafficRuleSegment each : segments) {
            TrafficRuleConverter.setConfigurationData(result, each);
        }
        return result;
    }

    private static void setConfigurationData(TrafficRuleConfiguration trafficRuleConfig, TrafficRuleSegment segment) {
        AlgorithmConfiguration trafficAlgorithm = TrafficRuleConverter.createAlgorithmConfiguration(segment.getAlgorithm());
        AlgorithmConfiguration loadBalancer = TrafficRuleConverter.createAlgorithmConfiguration(segment.getLoadBalancer());
        String trafficAlgorithmName = TrafficRuleConverter.createAlgorithmName(segment.getName(), trafficAlgorithm);
        String loadBalancerName = TrafficRuleConverter.createAlgorithmName(segment.getName(), loadBalancer);
        TrafficStrategyConfiguration trafficStrategy = TrafficRuleConverter.createTrafficStrategy(segment, trafficAlgorithmName, loadBalancerName);
        trafficRuleConfig.getTrafficStrategies().add(trafficStrategy);
        trafficRuleConfig.getTrafficAlgorithms().put(trafficAlgorithmName, trafficAlgorithm);
        Optional.ofNullable(loadBalancerName).ifPresent(optional -> trafficRuleConfig.getLoadBalancers().put(loadBalancerName, loadBalancer));
    }

    private static AlgorithmConfiguration createAlgorithmConfiguration(AlgorithmSegment segment) {
        return null == segment ? null : new AlgorithmConfiguration(segment.getName(), segment.getProps());
    }

    private static String createAlgorithmName(String ruleName, AlgorithmConfiguration algorithm) {
        return null == algorithm ? null : String.format("%s_%s", ruleName, algorithm.getType()).toLowerCase();
    }

    private static TrafficStrategyConfiguration createTrafficStrategy(TrafficRuleSegment trafficRuleSegment, String trafficAlgorithmName, String loadBalancerName) {
        return new TrafficStrategyConfiguration(trafficRuleSegment.getName(), trafficRuleSegment.getLabels(), trafficAlgorithmName, loadBalancerName);
    }

    @Generated
    private TrafficRuleConverter() {
    }
}

