/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.traffic.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.traffic.api.config.TrafficRuleConfiguration;
import org.apache.shardingsphere.traffic.api.config.TrafficStrategyConfiguration;
import org.apache.shardingsphere.traffic.distsql.statement.queryable.ShowTrafficRulesStatement;
import org.apache.shardingsphere.traffic.rule.TrafficRule;

public final class ShowTrafficRuleExecutor
implements DistSQLQueryExecutor<ShowTrafficRulesStatement>,
DistSQLExecutorRuleAware<TrafficRule> {
    private TrafficRule rule;

    public Collection<String> getColumnNames(ShowTrafficRulesStatement sqlStatement) {
        return Arrays.asList("name", "labels", "algorithm_type", "algorithm_props", "load_balancer_type", "load_balancer_props");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowTrafficRulesStatement sqlStatement, ContextManager contextManager) {
        TrafficRuleConfiguration ruleConfig = this.rule.getConfiguration();
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        ruleConfig.getTrafficStrategies().stream().filter(each -> null == sqlStatement.getRuleName() || each.getName().equals(sqlStatement.getRuleName())).forEach(each -> result.add(this.buildRow((TrafficStrategyConfiguration)each, (AlgorithmConfiguration)ruleConfig.getTrafficAlgorithms().get(each.getAlgorithmName()), (AlgorithmConfiguration)ruleConfig.getLoadBalancers().get(each.getLoadBalancerName()))));
        return result;
    }

    private LocalDataQueryResultRow buildRow(TrafficStrategyConfiguration strategy, AlgorithmConfiguration trafficAlgorithm, AlgorithmConfiguration loadBalancer) {
        return new LocalDataQueryResultRow(new Object[]{strategy.getName(), String.join((CharSequence)",", strategy.getLabels()), null == trafficAlgorithm ? null : trafficAlgorithm.getType(), null == trafficAlgorithm ? null : trafficAlgorithm.getProps(), null == loadBalancer ? null : loadBalancer.getType(), null == loadBalancer ? null : loadBalancer.getProps()});
    }

    public Class<TrafficRule> getRuleClass() {
        return TrafficRule.class;
    }

    public Class<ShowTrafficRulesStatement> getType() {
        return ShowTrafficRulesStatement.class;
    }

    @Generated
    public void setRule(TrafficRule rule) {
        this.rule = rule;
    }
}

