/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.traffic.distsql.handler.update;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.global.GlobalRuleDefinitionExecutor;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.loadbalancer.core.LoadBalanceAlgorithm;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.traffic.api.config.TrafficRuleConfiguration;
import org.apache.shardingsphere.traffic.api.config.TrafficStrategyConfiguration;
import org.apache.shardingsphere.traffic.distsql.handler.convert.TrafficRuleConverter;
import org.apache.shardingsphere.traffic.distsql.segment.TrafficRuleSegment;
import org.apache.shardingsphere.traffic.distsql.statement.updatable.AlterTrafficRuleStatement;
import org.apache.shardingsphere.traffic.rule.TrafficRule;
import org.apache.shardingsphere.traffic.spi.TrafficAlgorithm;

public final class AlterTrafficRuleExecutor
implements GlobalRuleDefinitionExecutor<AlterTrafficRuleStatement, TrafficRule> {
    private TrafficRule rule;

    public void checkBeforeUpdate(AlterTrafficRuleStatement sqlStatement) {
        this.checkRuleNames(sqlStatement);
        this.checkAlgorithmNames(sqlStatement);
    }

    private void checkRuleNames(AlterTrafficRuleStatement sqlStatement) {
        Collection<String> notExistRuleNames = this.getNotExistRuleNames(sqlStatement);
        ShardingSpherePreconditions.checkState((boolean)notExistRuleNames.isEmpty(), () -> new MissingRequiredRuleException("Traffic", notExistRuleNames));
    }

    private Collection<String> getNotExistRuleNames(AlterTrafficRuleStatement sqlStatement) {
        Collection currentRuleNames = this.rule.getConfiguration().getTrafficStrategies().stream().map(TrafficStrategyConfiguration::getName).collect(Collectors.toSet());
        return sqlStatement.getSegments().stream().map(TrafficRuleSegment::getName).filter(each -> !currentRuleNames.contains(each)).collect(Collectors.toSet());
    }

    private void checkAlgorithmNames(AlterTrafficRuleStatement sqlStatement) {
        sqlStatement.getSegments().forEach(each -> {
            TypedSPILoader.checkService(TrafficAlgorithm.class, (Object)each.getAlgorithm().getName(), (Properties)each.getAlgorithm().getProps());
            if (null != each.getLoadBalancer()) {
                TypedSPILoader.checkService(LoadBalanceAlgorithm.class, (Object)each.getLoadBalancer().getName(), (Properties)each.getLoadBalancer().getProps());
            }
        });
    }

    public TrafficRuleConfiguration buildToBeAlteredRuleConfiguration(AlterTrafficRuleStatement sqlStatement) {
        TrafficRuleConfiguration result = new TrafficRuleConfiguration();
        TrafficRuleConfiguration configFromSQLStatement = TrafficRuleConverter.convert(sqlStatement.getSegments());
        result.getTrafficStrategies().addAll(this.createToBeAlteredStrategyConfigurations(configFromSQLStatement));
        result.getTrafficAlgorithms().putAll(this.createToBeAlteredTrafficAlgorithms(configFromSQLStatement, this.getInUsedTrafficAlgorithm(result)));
        result.getLoadBalancers().putAll(this.createToBeAlteredLoadBalancers(configFromSQLStatement, this.getInUsedLoadBalancer(result)));
        return result;
    }

    private Collection<TrafficStrategyConfiguration> createToBeAlteredStrategyConfigurations(TrafficRuleConfiguration configFromSQLStatement) {
        LinkedList<TrafficStrategyConfiguration> result = new LinkedList<TrafficStrategyConfiguration>(this.rule.getConfiguration().getTrafficStrategies());
        Collection toBeAlteredConfigNames = configFromSQLStatement.getTrafficStrategies().stream().map(TrafficStrategyConfiguration::getName).collect(Collectors.toSet());
        result.removeIf(each -> toBeAlteredConfigNames.contains(each.getName()));
        result.addAll(configFromSQLStatement.getTrafficStrategies());
        return result;
    }

    private Collection<String> getInUsedTrafficAlgorithm(TrafficRuleConfiguration config) {
        return config.getTrafficStrategies().stream().map(TrafficStrategyConfiguration::getAlgorithmName).collect(Collectors.toSet());
    }

    private Map<String, AlgorithmConfiguration> createToBeAlteredTrafficAlgorithms(TrafficRuleConfiguration configFromSQLStatement, Collection<String> inUsedTrafficAlgorithm) {
        LinkedHashMap<String, AlgorithmConfiguration> result = new LinkedHashMap<String, AlgorithmConfiguration>(this.rule.getConfiguration().getTrafficAlgorithms());
        result.putAll(configFromSQLStatement.getTrafficAlgorithms());
        for (String each2 : result.keySet().stream().filter(each -> !inUsedTrafficAlgorithm.contains(each)).collect(Collectors.toSet())) {
            result.remove(each2);
        }
        return result;
    }

    private Collection<String> getInUsedLoadBalancer(TrafficRuleConfiguration config) {
        return config.getTrafficStrategies().stream().map(TrafficStrategyConfiguration::getLoadBalancerName).collect(Collectors.toSet());
    }

    private Map<String, AlgorithmConfiguration> createToBeAlteredLoadBalancers(TrafficRuleConfiguration configFromSQLStatement, Collection<String> inUsedLoadBalancer) {
        LinkedHashMap<String, AlgorithmConfiguration> result = new LinkedHashMap<String, AlgorithmConfiguration>(this.rule.getConfiguration().getLoadBalancers());
        result.putAll(configFromSQLStatement.getLoadBalancers());
        for (String each2 : result.keySet().stream().filter(each -> !inUsedLoadBalancer.contains(each)).collect(Collectors.toSet())) {
            result.remove(each2);
        }
        return result;
    }

    public Class<TrafficRule> getRuleClass() {
        return TrafficRule.class;
    }

    public Class<AlterTrafficRuleStatement> getType() {
        return AlterTrafficRuleStatement.class;
    }

    @Generated
    public void setRule(TrafficRule rule) {
        this.rule = rule;
    }
}

