/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.base.seata.at;

import io.seata.core.context.RootContext;
import java.util.List;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionProperties;
import org.apache.shardingsphere.infra.executor.sql.hook.SQLExecutionHook;
import org.apache.shardingsphere.transaction.base.seata.at.SeataXIDContext;

public final class SeataTransactionalSQLExecutionHook
implements SQLExecutionHook {
    private boolean seataBranch;

    public void start(String dataSourceName, String sql, List<Object> params, ConnectionProperties connectionProps, boolean isTrunkThread) {
        if (isTrunkThread) {
            if (RootContext.inGlobalTransaction()) {
                SeataXIDContext.set(RootContext.getXID());
            }
        } else if (!RootContext.inGlobalTransaction() && !SeataXIDContext.isEmpty()) {
            RootContext.bind((String)SeataXIDContext.get());
            this.seataBranch = true;
        }
    }

    public void finishSuccess() {
        if (this.seataBranch) {
            RootContext.unbind();
        }
    }

    public void finishFailure(Exception cause) {
        if (this.seataBranch) {
            RootContext.unbind();
        }
    }
}

