/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.springmvc.register;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.register.ApiBean;
import org.apache.shenyu.client.core.register.ClientRegisterConfig;
import org.apache.shenyu.client.core.register.matcher.AnnotatedApiDefinitionMatcher;
import org.apache.shenyu.client.core.register.matcher.Matcher;
import org.apache.shenyu.client.core.register.registrar.AbstractApiMetaRegistrar;
import org.apache.shenyu.client.springmvc.annotation.ShenyuSpringMvcClient;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.PathUtils;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.springframework.core.annotation.AnnotationUtils;

public class SpringMvcApiMetaRegister
extends AbstractApiMetaRegistrar {
    private final Matcher<ApiBean.ApiDefinition> apiDefinitionMatcher = new AnnotatedApiDefinitionMatcher(ShenyuSpringMvcClient.class).or(api -> AnnotationUtils.isAnnotationDeclaredLocally(ShenyuSpringMvcClient.class, (Class)api.getBeanClass()));
    private final Boolean addPrefixed;
    private final String appName;
    private final String host;
    private final Integer port;
    private final ClientRegisterConfig clientRegisterConfig;

    public SpringMvcApiMetaRegister(ShenyuClientRegisterEventPublisher publisher, ClientRegisterConfig clientRegisterConfig) {
        super(publisher);
        this.addPrefixed = clientRegisterConfig.getAddPrefixed();
        this.appName = clientRegisterConfig.getAppName();
        this.host = clientRegisterConfig.getHost();
        this.port = clientRegisterConfig.getPort();
        this.clientRegisterConfig = clientRegisterConfig;
    }

    protected Boolean preMatch(ApiBean apiBean) {
        ShenyuSpringMvcClient annotation = (ShenyuSpringMvcClient)apiBean.getAnnotation(ShenyuSpringMvcClient.class);
        return Objects.nonNull(annotation) && annotation.path()[0].endsWith("/**");
    }

    protected MetaDataRegisterDTO preParse(ApiBean apiBean) {
        ShenyuSpringMvcClient annotation = (ShenyuSpringMvcClient)apiBean.getAnnotation(ShenyuSpringMvcClient.class);
        String apiPath = PathUtils.pathJoin((String[])new String[]{this.clientRegisterConfig.getContextPath(), annotation.path()[0]});
        return MetaDataRegisterDTO.builder().contextPath(this.clientRegisterConfig.getContextPath()).addPrefixed(this.addPrefixed.booleanValue()).appName(this.appName).serviceName(apiBean.getBeanClass().getName()).host(this.host).port(this.port).methodName(null).path(apiPath).pathDesc(annotation.desc()).parameterTypes(null).rpcType(RpcTypeEnum.HTTP.getName()).enabled(annotation.enabled()).ruleName((String)StringUtils.defaultIfBlank((CharSequence)annotation.ruleName(), (CharSequence)apiPath)).registerMetaData(annotation.registerMetaData()).build();
    }

    protected Boolean match(ApiBean apiBean) {
        ShenyuSpringMvcClient annotation = (ShenyuSpringMvcClient)apiBean.getAnnotation(ShenyuSpringMvcClient.class);
        if (Objects.nonNull(annotation)) {
            return !annotation.path()[0].endsWith("/**");
        }
        return true;
    }

    protected Boolean match(ApiBean.ApiDefinition apiDefinition) {
        return this.apiDefinitionMatcher.match((Object)apiDefinition);
    }

    protected List<MetaDataRegisterDTO> parse(ApiBean.ApiDefinition apiDefinition) {
        ShenyuSpringMvcClient classAnnotation;
        String methodPath;
        ShenyuSpringMvcClient methodAnnotation = (ShenyuSpringMvcClient)apiDefinition.getAnnotation(ShenyuSpringMvcClient.class);
        String string = methodPath = Objects.isNull(methodAnnotation) ? "" : methodAnnotation.path()[0];
        if (StringUtils.isEmpty((CharSequence)methodPath)) {
            methodPath = apiDefinition.getMethodPath();
        }
        String beanPath = Objects.isNull(classAnnotation = (ShenyuSpringMvcClient)apiDefinition.getApiBean().getAnnotation(ShenyuSpringMvcClient.class)) || StringUtils.isBlank((CharSequence)classAnnotation.path()[0]) ? apiDefinition.getBeanPath() : classAnnotation.path()[0];
        String apiPath = PathUtils.pathJoin((String[])new String[]{this.clientRegisterConfig.getContextPath(), beanPath, methodPath});
        String pathDesc = Objects.isNull(methodAnnotation) ? classAnnotation.desc() : methodAnnotation.desc();
        boolean enabled = !(!Objects.isNull(classAnnotation) && !classAnnotation.enabled() || !Objects.isNull(methodAnnotation) && !methodAnnotation.enabled());
        String ruleName = Objects.isNull(methodAnnotation) || StringUtils.isEmpty((CharSequence)methodAnnotation.ruleName()) ? apiPath : methodAnnotation.ruleName();
        boolean registerMetaData = !(!Objects.isNull(classAnnotation) && !classAnnotation.registerMetaData() || !Objects.isNull(methodAnnotation) && !methodAnnotation.registerMetaData());
        return Lists.newArrayList((Object[])new MetaDataRegisterDTO[]{MetaDataRegisterDTO.builder().contextPath(this.clientRegisterConfig.getContextPath()).addPrefixed(this.addPrefixed.booleanValue()).appName(this.appName).host(this.host).port(this.port).serviceName(apiDefinition.getBeanClass().getName()).methodName(apiDefinition.getApiMethodName()).path(apiPath).pathDesc(pathDesc).parameterTypes(apiDefinition.getParameterTypes()).rpcType(RpcTypeEnum.HTTP.getName()).enabled(enabled).ruleName(ruleName).registerMetaData(registerMetaData).build()});
    }
}

