/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.enums;

import java.util.Arrays;
import lombok.Generated;
import org.apache.shenyu.common.exception.ShenyuException;

public enum HttpMethodEnum {
    GET("get", true),
    POST("post", true),
    PUT("put", true),
    DELETE("delete", true);

    private final String name;
    private final Boolean support;

    public static HttpMethodEnum acquireByName(String name) {
        return Arrays.stream(HttpMethodEnum.values()).filter(e -> e.support != false && e.name.equals(name)).findFirst().orElseThrow(() -> new ShenyuException(String.format(" this http method can not support %s", name)));
    }

    @Generated
    private HttpMethodEnum(String name, Boolean support) {
        this.name = name;
        this.support = support;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getSupport() {
        return this.support;
    }
}

