/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.enums;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public enum PluginEnum {
    GLOBAL(1, 0, "global"),
    SIGN(2, 0, "sign"),
    JWT(9, 0, "jwt"),
    OAUTH2(3, 0, "oauth2"),
    WAF(10, 0, "waf"),
    RATE_LIMITER(20, 0, "rate_limiter"),
    PARAM_MAPPING(22, 0, "param_mapping"),
    CONTEXT_PATH(25, 0, "context_path"),
    REWRITE(30, 0, "rewrite"),
    REDIRECT(40, 0, "redirect"),
    REQUEST(42, 0, "request"),
    MODIFY_RESPONSE(44, 0, "modifyResponse"),
    HYSTRIX(45, 0, "hystrix"),
    SENTINEL(45, 0, "sentinel"),
    RESILIENCE4J(45, 0, "resilience4j"),
    LOGGING(45, 0, "logging"),
    DIVIDE(50, 0, "divide"),
    SPRING_CLOUD(50, 0, "springCloud"),
    WEB_SOCKET(55, 0, "webSocket"),
    PARAM_TRANSFORM(58, 0, "paramTransform"),
    DUBBO(60, 0, "dubbo"),
    SOFA(60, 0, "sofa"),
    TARS(60, 0, "tars"),
    GRPC(60, 0, "grpc"),
    MOTAN(60, 0, "motan"),
    MONITOR(80, 0, "monitor"),
    RESPONSE(100, 0, "response");

    private final int code;
    private final int role;
    private final String name;

    public static PluginEnum getPluginEnumByName(String name) {
        return Arrays.stream(PluginEnum.values()).filter(pluginEnum -> pluginEnum.getName().equals(name)).findFirst().orElse(GLOBAL);
    }

    public static List<String> getUpstreamNames() {
        return Arrays.asList(PluginEnum.DIVIDE.name, PluginEnum.GRPC.name, PluginEnum.TARS.name);
    }

    @Generated
    private PluginEnum(int code, int role, String name) {
        this.code = code;
        this.role = role;
        this.name = name;
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public int getRole() {
        return this.role;
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

