/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shenyu.common.exception.ShenyuException;

public enum RpcTypeEnum {
    HTTP("http", true),
    DUBBO("dubbo", true),
    SOFA("sofa", true),
    TARS("tars", true),
    WEB_SOCKET("websocket", true),
    SPRING_CLOUD("springCloud", true),
    MOTAN("motan", true),
    GRPC("grpc", true);

    private final String name;
    private final Boolean support;

    public static List<RpcTypeEnum> acquireSupports() {
        return Arrays.stream(RpcTypeEnum.values()).filter(e -> e.support).collect(Collectors.toList());
    }

    public static List<RpcTypeEnum> acquireSupportURIs() {
        return Arrays.asList(GRPC, HTTP, TARS);
    }

    public static List<RpcTypeEnum> acquireSupportMetadatas() {
        return Arrays.asList(DUBBO, GRPC, HTTP, SPRING_CLOUD, SOFA, TARS);
    }

    public static RpcTypeEnum acquireByName(String name) {
        return Arrays.stream(RpcTypeEnum.values()).filter(e -> e.support != false && e.name.equals(name)).findFirst().orElseThrow(() -> new ShenyuException(String.format(" this rpc type can not support %s", name)));
    }

    @Generated
    private RpcTypeEnum(String name, Boolean support) {
        this.name = name;
        this.support = support;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getSupport() {
        return this.support;
    }
}

