/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    private static final String DATE_FORMAT_DATETIME = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static LocalDateTime parseLocalDateTime(String dataTime) {
        return LocalDateTime.parse(dataTime, DateTimeFormatter.ofPattern(DATE_FORMAT_DATETIME));
    }

    public static LocalDateTime parseLocalDateTime(String dataTime, String dateTimeFormatter) {
        return LocalDateTime.parse(dataTime, DateTimeFormatter.ofPattern(dateTimeFormatter));
    }

    public static long acquireMinutesBetween(LocalDateTime start, LocalDateTime end) {
        return start.until(end, ChronoUnit.MINUTES);
    }

    public static long acquireMillisBetween(LocalDateTime start, LocalDateTime end) {
        return start.until(end, ChronoUnit.MILLIS);
    }

    public static LocalDateTime formatLocalDateTimeFromTimestamp(Long timestamp) {
        return LocalDateTime.ofEpochSecond(timestamp / 1000L, 0, ZoneOffset.ofHours(8));
    }

    public static LocalDateTime formatLocalDateTimeFromTimestampBySystemTimezone(Long timestamp) {
        return LocalDateTime.ofEpochSecond(timestamp / 1000L, 0, OffsetDateTime.now().getOffset());
    }

    public static String localDateTimeToString(LocalDateTime localDateTime) {
        return DATE_TIME_FORMATTER.format(localDateTime);
    }

    public static String localDateTimeToString(LocalDateTime localDateTime, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return localDateTime.format(formatter);
    }
}

