/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.regex.Pattern;

public final class IpUtils {
    private static final Pattern IP_PATTERN = Pattern.compile("^((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)($|(?!\\.$)\\.)){4}$");

    private IpUtils() {
    }

    public static String getHost() {
        return IpUtils.getHost(null);
    }

    public static String getHost(String filterHost) {
        String firstHostIp = null;
        String hostIp = null;
        String pattern = filterHost;
        if (filterHost != null && !filterHost.contains("*") && !IpUtils.isCompleteHost(filterHost)) {
            pattern = filterHost + "*";
        }
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            block2: while (networkInterfaces.hasMoreElements()) {
                NetworkInterface network = networkInterfaces.nextElement();
                Enumeration<InetAddress> addresses = network.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress inetAddress = addresses.nextElement();
                    String hostAddress = inetAddress.getHostAddress();
                    if (!hostAddress.contains(".") || inetAddress.isLoopbackAddress()) continue;
                    if (firstHostIp == null) {
                        firstHostIp = hostAddress;
                        if (filterHost == null) continue block2;
                    }
                    if (pattern == null || !IpUtils.ipMatch(hostAddress, pattern)) continue;
                    hostIp = hostAddress;
                }
            }
            if (hostIp == null && firstHostIp != null) {
                hostIp = firstHostIp;
            }
            if (hostIp == null) {
                hostIp = InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (Exception ignore) {
            hostIp = "127.0.0.1";
        }
        return hostIp;
    }

    public static boolean isCompleteHost(String host) {
        if (host == null) {
            return false;
        }
        return IP_PATTERN.matcher(host).matches();
    }

    private static boolean ipMatch(String ip, String pattern) {
        int i;
        int m = ip.length();
        int n = pattern.length();
        boolean[][] dp = new boolean[m + 1][n + 1];
        dp[0][0] = true;
        for (i = 1; i <= n && pattern.charAt(i - 1) == '*'; ++i) {
            dp[0][i] = true;
        }
        for (i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                if (pattern.charAt(j - 1) == '*') {
                    dp[i][j] = dp[i][j - 1] || dp[i - 1][j];
                    continue;
                }
                if (pattern.charAt(j - 1) != '?' && ip.charAt(i - 1) != pattern.charAt(j - 1)) continue;
                dp[i][j] = dp[i - 1][j - 1];
            }
        }
        return dp[m][n];
    }
}

