/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.dto;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class MetaData {
    private String id;
    private String appName;
    private String contextPath;
    private String path;
    private String rpcType;
    private String serviceName;
    private String methodName;
    private String parameterTypes;
    private String rpcExt;
    private Boolean enabled;

    public MetaData() {
    }

    public MetaData(String id, String appName, String contextPath, String path, String rpcType, String serviceName, String methodName, String parameterTypes, String rpcExt, Boolean enabled) {
        this.id = id;
        this.appName = appName;
        this.contextPath = contextPath;
        this.path = path;
        this.rpcType = rpcType;
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.rpcExt = rpcExt;
        this.enabled = enabled;
    }

    private MetaData(Builder builder) {
        this.id = builder.id;
        this.appName = builder.appName;
        this.contextPath = builder.contextPath;
        this.path = builder.path;
        this.rpcType = builder.rpcType;
        this.serviceName = builder.serviceName;
        this.methodName = builder.methodName;
        this.parameterTypes = builder.parameterTypes;
        this.rpcExt = builder.rpcExt;
        this.enabled = builder.enabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getRpcType() {
        return this.rpcType;
    }

    public void setRpcType(String rpcType) {
        this.rpcType = rpcType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(String parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public String getRpcExt() {
        return this.rpcExt;
    }

    public void setRpcExt(String rpcExt) {
        this.rpcExt = rpcExt;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaData metaData = (MetaData)o;
        return Objects.equals(this.id, metaData.id) && Objects.equals(this.appName, metaData.appName) && Objects.equals(this.contextPath, metaData.contextPath) && Objects.equals(this.path, metaData.path) && Objects.equals(this.rpcType, metaData.rpcType) && Objects.equals(this.serviceName, metaData.serviceName) && Objects.equals(this.methodName, metaData.methodName) && Objects.equals(this.parameterTypes, metaData.parameterTypes) && Objects.equals(this.rpcExt, metaData.rpcExt) && Objects.equals(this.enabled, metaData.enabled);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.appName, this.contextPath, this.path, this.rpcType, this.serviceName, this.methodName, this.parameterTypes, this.rpcExt, this.enabled);
    }

    public String toString() {
        return "MetaData{id='" + this.id + '\'' + ", appName='" + this.appName + '\'' + ", contextPath='" + this.contextPath + '\'' + ", path='" + this.path + '\'' + ", rpcType='" + this.rpcType + '\'' + ", serviceName='" + this.serviceName + '\'' + ", methodName='" + this.methodName + '\'' + ", parameterTypes='" + this.parameterTypes + '\'' + ", rpcExt='" + this.rpcExt + '\'' + ", enabled=" + this.enabled + '}';
    }

    public void updateContextPath() {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.path})) {
            this.contextPath = StringUtils.indexOf((CharSequence)this.path, (CharSequence)"/", (int)1) > -1 ? this.path.substring(0, StringUtils.indexOf((CharSequence)this.path, (CharSequence)"/", (int)1)) : this.path;
        }
    }

    public static final class Builder {
        private String id;
        private String appName;
        private String contextPath;
        private String path;
        private String rpcType;
        private String serviceName;
        private String methodName;
        private String parameterTypes;
        private String rpcExt;
        private Boolean enabled;

        private Builder() {
        }

        public MetaData build() {
            return new MetaData(this);
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder rpcType(String rpcType) {
            this.rpcType = rpcType;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder methodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public Builder parameterTypes(String parameterTypes) {
            this.parameterTypes = parameterTypes;
            return this;
        }

        public Builder rpcExt(String rpcExt) {
            this.rpcExt = rpcExt;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }
    }
}

