/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.enums;

import java.util.Arrays;
import java.util.List;

public enum PluginEnum {
    GLOBAL(10, 0, "global"),
    SIGN(20, 0, "sign"),
    JWT(30, 0, "jwt"),
    OAUTH2(40, 0, "oauth2"),
    WAF(50, 0, "waf"),
    RATE_LIMITER(60, 0, "rate_limiter"),
    PARAM_MAPPING(70, 0, "param_mapping"),
    CONTEXT_PATH(80, 0, "context_path"),
    REWRITE(90, 0, "rewrite"),
    CRYPTOR_REQUEST(100, 0, "cryptor_request"),
    REDIRECT(110, 0, "redirect"),
    REQUEST(120, 0, "request"),
    HYSTRIX(130, 0, "hystrix"),
    SENTINEL(140, 0, "sentinel"),
    RESILIENCE4J(150, 0, "resilience4j"),
    LOGGING(160, 0, "logging"),
    MONITOR(170, 0, "monitor"),
    DIVIDE(200, 0, "divide"),
    SPRING_CLOUD(200, 0, "springCloud"),
    WEB_SOCKET(200, 0, "websocket"),
    WEB_CLIENT(210, 0, "webClient"),
    NETTY_HTTP_CLIENT(210, 0, "nettyHttpClient"),
    MODIFY_RESPONSE(220, 0, "modifyResponse"),
    RPC_PARAM_TRANSFORM(300, 0, "paramTransform"),
    DUBBO(310, 0, "dubbo"),
    SOFA(310, 0, "sofa"),
    TARS(310, 0, "tars"),
    GRPC(310, 0, "grpc"),
    MOTAN(310, 0, "motan"),
    CRYPTOR_RESPONSE(410, 0, "cryptor_response"),
    RESPONSE(420, 0, "response");

    private final int code;
    private final int role;
    private final String name;

    private PluginEnum(int code, int role, String name) {
        this.code = code;
        this.role = role;
        this.name = name;
    }

    public int getCode() {
        return this.code;
    }

    public int getRole() {
        return this.role;
    }

    public String getName() {
        return this.name;
    }

    public static PluginEnum getPluginEnumByName(String name) {
        return Arrays.stream(PluginEnum.values()).filter(pluginEnum -> pluginEnum.getName().equals(name)).findFirst().orElse(GLOBAL);
    }

    public static List<String> getUpstreamNames() {
        return Arrays.asList(PluginEnum.DIVIDE.name, PluginEnum.GRPC.name, PluginEnum.TARS.name, PluginEnum.SPRING_CLOUD.name, PluginEnum.DUBBO.name);
    }
}

