/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.exception.ShenyuException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;

public class GsonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(GsonUtils.class);
    private static final GsonUtils INSTANCE = new GsonUtils();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(String.class, (Object)new StringTypeAdapter()).registerTypeHierarchyAdapter(Pair.class, (Object)new PairTypeAdapter()).registerTypeHierarchyAdapter(Duration.class, (Object)new DurationTypeAdapter()).create();
    private static final Gson GSON_MAP = new GsonBuilder().serializeNulls().registerTypeHierarchyAdapter(new TypeToken<Map<String, Object>>(){}.getRawType(), new MapDeserializer()).create();
    private static final String DOT = ".";
    private static final String E = "e";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String LEFT_ANGLE_BRACKETS = "{";
    private static final String RIGHT_ANGLE_BRACKETS = "}";
    private static final String EMPTY = "";
    private static final String EQUAL_SIGN = "=";
    private static final String AND = "&";

    public static Gson getGson() {
        return GSON;
    }

    public static GsonUtils getInstance() {
        return INSTANCE;
    }

    public String toJson(Object object) {
        return GSON.toJson(object);
    }

    public <T> T fromJson(String json, Class<T> tClass) {
        return (T)GSON.fromJson(json, tClass);
    }

    public <T> T fromJson(JsonElement jsonElement, Class<T> tClass) {
        return (T)GSON.fromJson(jsonElement, tClass);
    }

    public <T> List<T> fromList(String json, Class<T> clazz) {
        return (List)GSON.fromJson(json, TypeToken.getParameterized(List.class, (Type[])new Type[]{clazz}).getType());
    }

    public <T> List<T> fromCurrentList(String json, Class<T> clazz) {
        return (List)GSON.fromJson(json, TypeToken.getParameterized(CopyOnWriteArrayList.class, (Type[])new Type[]{clazz}).getType());
    }

    public String toGetParam(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return EMPTY;
        }
        Map<String, String> map = this.toStringMap(json);
        StringBuilder stringBuilder = new StringBuilder();
        map.forEach((k, v) -> {
            try {
                stringBuilder.append((String)k).append(EQUAL_SIGN).append(URLDecoder.decode(v, "UTF-8")).append(AND);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        });
        String r = stringBuilder.toString();
        return r.substring(0, r.lastIndexOf(AND));
    }

    private Map<String, String> toStringMap(String json) {
        return (Map)GSON.fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
    }

    public List<Map<String, Object>> toListMap(String json) {
        return (List)GSON.fromJson(json, new TypeToken<List<Map<String, Object>>>(){}.getType());
    }

    public Map<String, Object> toObjectMap(String json) {
        return (Map)GSON_MAP.fromJson(json, new TypeToken<LinkedHashMap<String, Object>>(){}.getType());
    }

    public <T> Map<String, T> toObjectMap(String json, Class<T> clazz) {
        return (Map)GSON.fromJson(json, TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, clazz}).getType());
    }

    public <T> Map<String, List<T>> toObjectMapList(String json, Class<T> clazz) {
        return (Map)GSON.fromJson(json, TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, TypeToken.getParameterized(List.class, (Type[])new Type[]{clazz}).getType()}).getType());
    }

    public ConcurrentNavigableMap<String, Object> toTreeMap(String json) {
        return (ConcurrentNavigableMap)GSON_MAP.fromJson(json, new TypeToken<ConcurrentSkipListMap<String, Object>>(){}.getType());
    }

    public LinkedMultiValueMap<String, String> toLinkedMultiValueMap(String json) {
        return (LinkedMultiValueMap)GSON.fromJson(json, new TypeToken<LinkedMultiValueMap<String, String>>(){}.getType());
    }

    public Map<String, Object> convertToMap(String json) {
        Map map = (Map)GSON_MAP.fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
        if (map == null || map.isEmpty()) {
            return map;
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                String valueStr = ((String)value).trim();
                if (!valueStr.startsWith(LEFT_ANGLE_BRACKETS) || !valueStr.endsWith(RIGHT_ANGLE_BRACKETS)) continue;
                Map<String, Object> mv = this.convertToMap(value.toString());
                map.put(key, mv);
                continue;
            }
            if (value instanceof JsonObject) {
                map.put(key, this.convertToMap(value.toString()));
                continue;
            }
            if (value instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)value;
                map.put(key, this.jsonArrayToListInConvertToMap(jsonArray));
                continue;
            }
            if (!(value instanceof JsonNull)) continue;
            map.put(key, null);
        }
        return map;
    }

    private List<Object> jsonArrayToListInConvertToMap(JsonArray jsonArray) {
        ArrayList<Object> list = new ArrayList<Object>(jsonArray.size());
        for (JsonElement jsonElement : jsonArray) {
            if (jsonElement.isJsonNull()) {
                list.add(null);
                continue;
            }
            String objStr = jsonElement.getAsString();
            if (objStr.startsWith(LEFT_ANGLE_BRACKETS) && objStr.endsWith(RIGHT_ANGLE_BRACKETS)) {
                list.add(this.convertToMap(jsonElement.toString()));
                continue;
            }
            list.add(objStr);
        }
        return list;
    }

    private static class DurationTypeAdapter
    extends TypeAdapter<Duration> {
        private DurationTypeAdapter() {
        }

        public void write(JsonWriter out, Duration value) {
            try {
                if (value == null) {
                    out.nullValue();
                    return;
                }
                out.value(value.toString());
            }
            catch (IOException e) {
                LOG.error("failed to write", (Throwable)e);
            }
        }

        public Duration read(JsonReader reader) {
            try {
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    return null;
                }
                return Duration.parse(reader.nextString());
            }
            catch (IOException e) {
                throw new ShenyuException(e);
            }
        }
    }

    private static class PairTypeAdapter
    extends TypeAdapter<Pair<String, String>> {
        private PairTypeAdapter() {
        }

        public void write(JsonWriter out, Pair<String, String> value) throws IOException {
            out.beginObject();
            out.name(GsonUtils.LEFT).value((String)value.getLeft());
            out.name(GsonUtils.RIGHT).value((String)value.getRight());
            out.endObject();
        }

        public Pair<String, String> read(JsonReader in) throws IOException {
            in.beginObject();
            String left = null;
            String right = null;
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "left": {
                        left = in.nextString();
                        break;
                    }
                    case "right": {
                        right = in.nextString();
                        break;
                    }
                }
            }
            in.endObject();
            return Pair.of(left, right);
        }
    }

    private static class StringTypeAdapter
    extends TypeAdapter<String> {
        private StringTypeAdapter() {
        }

        public void write(JsonWriter out, String value) {
            try {
                if (StringUtils.isBlank((CharSequence)value)) {
                    out.nullValue();
                    return;
                }
                out.value(value);
            }
            catch (IOException e) {
                LOG.error("failed to write", (Throwable)e);
            }
        }

        public String read(JsonReader reader) {
            try {
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    return GsonUtils.EMPTY;
                }
                return reader.nextString();
            }
            catch (IOException e) {
                throw new ShenyuException(e);
            }
        }
    }

    private static class MapDeserializer<T, U>
    implements JsonDeserializer<Map<T, U>> {
        private MapDeserializer() {
        }

        public Map<T, U> deserialize(JsonElement json, Type type, JsonDeserializationContext context) {
            if (!json.isJsonObject()) {
                return null;
            }
            JsonObject jsonObject = json.getAsJsonObject();
            Set jsonEntrySet = jsonObject.entrySet();
            String className = ((ParameterizedType)type).getRawType().getTypeName();
            Class<?> mapClass = null;
            try {
                mapClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                LOG.error("failed to get class", (Throwable)e);
            }
            Map resultMap = null;
            if (mapClass.isInterface()) {
                resultMap = new LinkedHashMap();
            } else {
                try {
                    resultMap = (Map)mapClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    LOG.error("failed to get constructor", (Throwable)e);
                }
            }
            for (Map.Entry entry : jsonEntrySet) {
                if (((JsonElement)entry.getValue()).isJsonNull()) {
                    resultMap.put(entry.getKey(), null);
                    continue;
                }
                Object value = context.deserialize((JsonElement)entry.getValue(), this.getType((JsonElement)entry.getValue()));
                resultMap.put(entry.getKey(), value);
            }
            return resultMap;
        }

        public Class<?> getType(JsonElement element) {
            if (!element.isJsonPrimitive()) {
                return element.getClass();
            }
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isString()) {
                return String.class;
            }
            if (primitive.isNumber()) {
                String numStr = primitive.getAsString();
                if (numStr.contains(GsonUtils.DOT) || numStr.contains(GsonUtils.E) || numStr.contains(GsonUtils.E.toUpperCase())) {
                    return Double.class;
                }
                return Long.class;
            }
            if (primitive.isBoolean()) {
                return Boolean.class;
            }
            return element.getClass();
        }
    }
}

