/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import java.util.Objects;

public class ThreadShare<T>
extends ThreadLocal<T> {
    private final Thread thread = Thread.currentThread();
    private final String name;

    public ThreadShare() {
        this.name = "default-share";
    }

    public ThreadShare(String name) {
        this.name = name;
    }

    public static <T> ThreadShare<T> create(String name) {
        return new ThreadShare<T>(name);
    }

    public T getRemove() {
        try {
            Object t = this.get();
            return t;
        }
        finally {
            this.remove();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreadShare that = (ThreadShare)o;
        return Objects.equals(this.thread, that.thread) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.thread, this.name);
    }
}

