/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.constant;

import org.apache.shenyu.common.constant.Constants;

public final class DefaultPathConstants
implements Constants {
    public static final String SELECTOR_JOIN_RULE = "-";
    private static final String PRE_FIX = "/shenyu";
    public static final String PLUGIN_PARENT = "/shenyu/plugin";
    public static final String SELECTOR_PARENT = "/shenyu/selector";
    public static final String RULE_PARENT = "/shenyu/rule";
    public static final String APP_AUTH_PARENT = "/shenyu/auth";
    public static final String META_DATA = "/shenyu/metaData";

    public static String buildAppAuthPath(String appKey) {
        return String.join((CharSequence)"/", APP_AUTH_PARENT, appKey);
    }

    public static String buildMetaDataPath(String path) {
        return String.join((CharSequence)"/", META_DATA, path);
    }

    public static String buildPluginParentPath() {
        return String.join((CharSequence)"/", PLUGIN_PARENT);
    }

    public static String buildPluginPath(String pluginName) {
        return String.join((CharSequence)"/", PLUGIN_PARENT, pluginName);
    }

    public static String buildSelectorParentPath(String pluginName) {
        return String.join((CharSequence)"/", SELECTOR_PARENT, pluginName);
    }

    public static String buildSelectorRealPath(String pluginName, String selectorId) {
        return String.join((CharSequence)"/", SELECTOR_PARENT, pluginName, selectorId);
    }

    public static String buildRuleParentPath(String pluginName) {
        return String.join((CharSequence)"/", RULE_PARENT, pluginName);
    }

    public static String buildRulePath(String pluginName, String selectorId, String ruleId) {
        return String.join((CharSequence)"/", DefaultPathConstants.buildRuleParentPath(pluginName), String.join((CharSequence)SELECTOR_JOIN_RULE, selectorId, ruleId));
    }
}

