/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.dto.convert.selector;

import java.util.Objects;
import org.apache.shenyu.common.dto.convert.selector.CommonUpstream;

public final class DubboUpstream
extends CommonUpstream {
    private String registry;
    private String appName;
    private int port;
    private Boolean gray;
    private String group;
    private String version;
    private int weight;
    private int warmup;

    private DubboUpstream(Builder builder) {
        boolean statusValue = builder.statusValue;
        if (!builder.statusSet) {
            statusValue = DubboUpstream.defaultStatus();
        }
        this.setUpstreamHost(builder.upstreamHost);
        this.setProtocol(builder.protocol);
        this.setUpstreamUrl(builder.upstreamUrl);
        this.weight = builder.weight;
        this.setStatus(statusValue);
        this.setTimestamp(builder.timestamp);
        this.warmup = builder.warmup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getRegistry() {
        return this.registry;
    }

    public void setRegistry(String registry) {
        this.registry = registry;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Boolean isGray() {
        return this.gray;
    }

    public void setGray(Boolean gray) {
        this.gray = gray;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getWarmup() {
        return this.warmup;
    }

    public void setWarmup(int warmup) {
        this.warmup = warmup;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DubboUpstream)) {
            return false;
        }
        DubboUpstream that = (DubboUpstream)o;
        return this.port == that.port && this.weight == that.weight && this.warmup == that.warmup && Objects.equals(this.registry, that.registry) && Objects.equals(this.appName, that.appName) && Objects.equals(this.getProtocol(), that.getProtocol()) && Objects.equals(this.getUpstreamUrl(), that.getUpstreamUrl()) && Objects.equals(this.gray, that.gray) && Objects.equals(this.group, that.group) && Objects.equals(this.version, that.version);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.registry, this.appName, this.port, this.gray, this.weight, this.warmup, this.group, this.version);
    }

    @Override
    public String toString() {
        return "DubboUpstream{registry='" + this.registry + ", appName='" + this.appName + ", protocol='" + this.getProtocol() + ", port=" + this.port + ", upstreamUrl='" + this.getUpstreamUrl() + ", gray=" + this.gray + ", weight=" + this.weight + ", warmup=" + this.warmup + ", group='" + this.group + ", version='" + this.version + '}';
    }

    public static final class Builder {
        private String upstreamHost;
        private String protocol;
        private String upstreamUrl;
        private int weight;
        private boolean statusSet;
        private boolean statusValue;
        private long timestamp;
        private int warmup;

        private Builder() {
        }

        public DubboUpstream build() {
            return new DubboUpstream(this);
        }

        public Builder upstreamHost(String upstreamHost) {
            this.upstreamHost = upstreamHost;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder upstreamUrl(String upstreamUrl) {
            this.upstreamUrl = upstreamUrl;
            return this;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder status(boolean status) {
            this.statusValue = status;
            this.statusSet = true;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder warmup(int warmup) {
            this.warmup = warmup;
            return this;
        }
    }
}

