/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum OperatorEnum {
    MATCH("match", true),
    EQ("=", true),
    REGEX("regex", true),
    GT(">", false),
    LT("<", false),
    CONTAINS("contains", true),
    TIME_BEFORE("TimeBefore", true),
    EXCLUDE("exclude", true),
    TIME_AFTER("TimeAfter", true);

    private final String alias;
    private final Boolean support;

    private OperatorEnum(String alias, Boolean support) {
        this.alias = alias;
        this.support = support;
    }

    public String getAlias() {
        return this.alias;
    }

    public Boolean getSupport() {
        return this.support;
    }

    public static List<OperatorEnum> acquireSupport() {
        return Arrays.stream(OperatorEnum.values()).filter(e -> e.support).collect(Collectors.toList());
    }

    public static OperatorEnum getOperatorEnumByAlias(String alias) {
        return Arrays.stream(OperatorEnum.values()).filter(e -> e.getAlias().equals(alias) && e.support != false).findFirst().orElse(null);
    }
}

