/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.shenyu.common.exception.ShenyuException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectUtils.class);

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields = beanClass.getDeclaredFields();
        return Arrays.stream(fields).filter(field -> Objects.equals(name, field.getName())).findFirst().orElse(null);
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        if (Objects.isNull(obj) || StringUtils.isBlank((CharSequence)fieldName)) {
            return null;
        }
        return ReflectUtils.getFieldValue(obj, ReflectUtils.getField(obj.getClass(), fieldName));
    }

    public static Object getFieldValue(Object obj, Field field) {
        if (Objects.isNull(obj) || Objects.isNull(field)) {
            return null;
        }
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            LOG.error("", (Throwable)e);
        }
        return result;
    }

    public static Object invokeMethod(Class<?> clazz, String method) {
        try {
            Method m = ReflectUtils.findMethod(clazz, method);
            assert (m != null);
            return m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }

    public static Method findMethod(Class<?> clazz, String method) {
        try {
            return clazz.getMethod(method, new Class[0]);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        Field field = ReflectUtils.getAccessibleField(obj, fieldName);
        if (Objects.isNull(field)) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + "]");
        }
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            LOG.error("Failed to assign to the element.", (Throwable)e);
            throw new ShenyuException(e.getMessage());
        }
    }

    private static Field getAccessibleField(Object obj, String fieldName) {
        Validate.notNull((Object)obj, (String)"object can't be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fieldName, (String)"fieldName can't be blank", (Object[])new Object[0]);
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                ReflectUtils.makeAccessible(field);
                return field;
            }
            catch (NoSuchFieldException e) {
                LOG.error("field is not defined in the current class and continues to transition up", (Throwable)e);
                continue;
            }
        }
        return null;
    }

    private static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static boolean isPrimitives(Class<?> cls) {
        return cls.isArray() ? ReflectUtils.isPrimitive(cls.getComponentType()) : ReflectUtils.isPrimitive(cls);
    }

    public static boolean isPrimitive(Class<?> cls) {
        return cls.isPrimitive() || cls == String.class || cls == Boolean.class || cls == Character.class || Number.class.isAssignableFrom(cls) || Date.class.isAssignableFrom(cls) || List.class.isAssignableFrom(cls);
    }
}

