/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.concurrent;

import java.lang.instrument.Instrumentation;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.common.concurrent.MemoryLimitedLinkedBlockingQueue;
import org.apache.shenyu.common.concurrent.ShenyuThreadPoolExecutor;

public class MemoryLimitedTaskQueue<R extends Runnable>
extends MemoryLimitedLinkedBlockingQueue<Runnable> {
    private static final long serialVersionUID = -2635853580887179627L;
    private ShenyuThreadPoolExecutor executor;

    public MemoryLimitedTaskQueue(Instrumentation inst) {
        super(inst);
    }

    public MemoryLimitedTaskQueue(long memoryLimit, Instrumentation inst) {
        super(memoryLimit, inst);
    }

    public void setExecutor(ShenyuThreadPoolExecutor executor) {
        this.executor = executor;
    }

    @Override
    public boolean offer(Runnable runnable) {
        if (this.executor == null) {
            throw new RejectedExecutionException("The task queue does not have executor!");
        }
        int currentPoolThreadSize = this.executor.getPoolSize();
        if (this.executor.getActiveCount() < currentPoolThreadSize) {
            return super.offer(runnable);
        }
        if (currentPoolThreadSize < this.executor.getMaximumPoolSize()) {
            return false;
        }
        return super.offer(runnable);
    }

    public boolean retryOffer(Runnable o, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.executor.isShutdown()) {
            throw new RejectedExecutionException("Executor is shutdown!");
        }
        return super.offer(o, timeout, unit);
    }
}

