/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.concurrent;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.common.concurrent.MemoryLimitedTaskQueue;

public class ShenyuThreadPoolExecutor
extends ThreadPoolExecutor {
    public ShenyuThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, MemoryLimitedTaskQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        try {
            super.execute(command);
        }
        catch (RejectedExecutionException e) {
            MemoryLimitedTaskQueue queue = (MemoryLimitedTaskQueue)super.getQueue();
            try {
                if (!queue.retryOffer(command, 0L, TimeUnit.MILLISECONDS)) {
                    throw new RejectedExecutionException("Queue capacity is full.", e);
                }
            }
            catch (InterruptedException t) {
                throw new RejectedExecutionException(t);
            }
        }
    }
}

