/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpstreamCheckUtils {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final Logger LOG = LoggerFactory.getLogger(UpstreamCheckUtils.class);

    public static boolean checkUrl(String url) {
        return UpstreamCheckUtils.checkUrl(url, 3000);
    }

    public static boolean checkUrl(String url, int timeout) {
        String[] hostPort;
        if (StringUtils.isBlank((CharSequence)url)) {
            return false;
        }
        if (url.startsWith(HTTP)) {
            String[] http = StringUtils.split((String)url, (String)"\\/\\/");
            hostPort = StringUtils.split((String)http[1], (String)":");
        } else {
            hostPort = StringUtils.split((String)url, (String)":");
        }
        boolean isHttps = url.startsWith(HTTPS);
        int port = hostPort.length > 1 ? Integer.parseInt(hostPort[1].trim()) : (isHttps ? 443 : 80);
        return UpstreamCheckUtils.isHostConnector(hostPort[0].trim(), port, timeout);
    }

    private static boolean isHostConnector(String host, int port, int timeout) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(host, port), timeout);
        }
        catch (Exception e) {
            LOG.error("socket connect is error.", (Throwable)e);
            return false;
        }
        return true;
    }
}

