/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.dto;

import java.util.Objects;

public class AuthPathData {
    private String appName;
    private String path;
    private Boolean enabled;

    public AuthPathData() {
    }

    public AuthPathData(String appName, String path, Boolean enabled) {
        this.appName = appName;
        this.path = path;
        this.enabled = enabled;
    }

    private AuthPathData(Builder builder) {
        this.appName = builder.appName;
        this.path = builder.path;
        this.enabled = builder.enabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthPathData that = (AuthPathData)o;
        return Objects.equals(this.appName, that.appName) && Objects.equals(this.path, that.path) && Objects.equals(this.enabled, that.enabled);
    }

    public int hashCode() {
        return Objects.hash(this.appName, this.path, this.enabled);
    }

    public String toString() {
        return "AuthPathData{appName='" + this.appName + '\'' + ", path='" + this.path + '\'' + ", enabled=" + this.enabled + '}';
    }

    public static final class Builder {
        private String appName;
        private String path;
        private Boolean enabled;

        private Builder() {
        }

        public AuthPathData build() {
            return new AuthPathData(this);
        }

        public Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }
    }
}

