/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.util.DigestUtils;

public final class SignUtils {
    private static final SignUtils SIGN_UTILS = new SignUtils();

    private SignUtils() {
    }

    public static SignUtils getInstance() {
        return SIGN_UTILS;
    }

    public static String generateSign(String signKey, Map<String, String> params) {
        String sign = params.keySet().stream().sorted(Comparator.naturalOrder()).filter(key -> !Objects.equals(key, "sign")).map(key -> String.join((CharSequence)"", key, (CharSequence)params.get(key))).collect(Collectors.joining()).trim().concat(signKey);
        return DigestUtils.md5DigestAsHex((byte[])sign.getBytes()).toUpperCase();
    }

    public boolean isValid(String sign, Map<String, String> params, String signKey) {
        return Objects.equals(sign, SignUtils.generateSign(signKey, params));
    }

    public String generateKey() {
        return UUID.randomUUID().toString().replaceAll("-", "").toUpperCase();
    }
}

