/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shenyu.common.constant;

/**
 * Polaris path constants.
 */
public final class PolarisPathConstants {

    /**
     * Polaris config default namespace.
     */
    public static final String NAMESPACE = "default";

    /**
     * Polaris file group.
     */
    public static final String FILE_GROUP = "shenyu";

    /**
     * auth data id.
     */
    public static final String AUTH_DATA_ID_FILE_NAME = "shenyu/auth.json";

    /**
     * plugin data id.
     */
    public static final String PLUGIN_DATA_FILE_NAME = "shenyu/plugin.json";

    /**
     * selector data id.
     */
    public static final String SELECTOR_DATA_FILE_NAME = "shenyu/selector.json";

    /**
     * rule data id.
     */
    public static final String RULE_DATA_FILE_NAME = "shenyu/rule.json";

    /**
     * meta data id.
     */
    public static final String META_DATA_FILE_NAME = "shenyu/meta.json";

    /**
     * proxy selector data id.
     */
    public static final String PROXY_SELECTOR_FILE_NAME = "shenyu/proxy/selector.json";

    /**
     * default value of get config.
     */
    public static final String EMPTY_CONFIG_DEFAULT_VALUE = "{}";
}
