/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shenyu.common.exception.ShenyuException;

public enum RpcTypeEnum {
    HTTP("http", true),
    DUBBO("dubbo", true),
    SOFA("sofa", true),
    TARS("tars", true),
    WEB_SOCKET("websocket", true),
    SPRING_CLOUD("springCloud", true),
    MOTAN("motan", true),
    GRPC("grpc", true),
    BRPC("brpc", true);

    private final String name;
    private final Boolean support;

    private RpcTypeEnum(String name, Boolean support) {
        this.name = name;
        this.support = support;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getSupport() {
        return this.support;
    }

    public static List<RpcTypeEnum> acquireSupports() {
        return Arrays.stream(RpcTypeEnum.values()).filter(e -> e.support).collect(Collectors.toList());
    }

    public static List<RpcTypeEnum> acquireSupportURIs() {
        return Arrays.asList(GRPC, HTTP, TARS, SPRING_CLOUD, DUBBO);
    }

    public static List<RpcTypeEnum> acquireSupportMetadatas() {
        return Arrays.asList(HTTP, DUBBO, GRPC, SPRING_CLOUD, SOFA, TARS, MOTAN);
    }

    public static List<RpcTypeEnum> acquireSupportSwaggers() {
        return Arrays.asList(HTTP, SPRING_CLOUD);
    }

    public static RpcTypeEnum acquireByName(String name) {
        return Arrays.stream(RpcTypeEnum.values()).filter(e -> e.support != false && e.name.equals(name)).findFirst().orElseThrow(() -> new ShenyuException(String.format(" this rpc type can not support %s", name)));
    }
}

