/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum PluginEnum {
    GLOBAL(-1, 0, "global"),
    TCP(0, 0, "tcp"),
    MQTT(0, 0, "mqtt"),
    MOCK(8, 0, "mock"),
    CACHE(10, 0, "cache"),
    METRICS(15, 0, "metrics"),
    SIGN(20, 0, "sign"),
    JWT(30, 0, "jwt"),
    OAUTH2(40, 0, "oauth2"),
    CASDOOR(40, 0, "casdoor"),
    WAF(50, 0, "waf"),
    RATE_LIMITER(60, 0, "rateLimiter"),
    PARAM_MAPPING(70, 0, "paramMapping"),
    CONTEXT_PATH(80, 0, "contextPath"),
    REWRITE(90, 0, "rewrite"),
    CRYPTOR_REQUEST(100, 0, "cryptorRequest"),
    REDIRECT(110, 0, "redirect"),
    REQUEST(120, 0, "request"),
    GENERAL_CONTEXT(125, 0, "generalContext"),
    HYSTRIX(130, 0, "hystrix"),
    SENTINEL(140, 0, "sentinel"),
    RESILIENCE4J(150, 0, "resilience4j"),
    LOGGING_CONSOLE(160, 0, "loggingConsole"),
    LOGGING_ROCKETMQ(170, 0, "loggingRocketMQ"),
    LOGGING_RABBITMQ(171, 0, "loggingRabbitMQ"),
    LOGGING_ALIYUN_SLS(175, 0, "loggingAliyunSls"),
    LOGGING_TENCENT_CLS(176, 0, "loggingTencentCls"),
    LOGGING_HUAWEI_LTS(177, 0, "loggingHuaweiLts"),
    LOGGING_KAFKA(180, 0, "loggingKafka"),
    LOGGING_PULSAR(185, 0, "loggingPulsar"),
    LOGGING_ELASTIC_SEARCH(190, 0, "loggingElasticSearch"),
    LOGGING_CLICK_HOUSE(195, 0, "loggingClickHouse"),
    DIVIDE(200, 0, "divide"),
    SPRING_CLOUD(200, 0, "springCloud"),
    WEB_SOCKET(200, 0, "websocket"),
    URI(205, 0, "uri"),
    WEB_CLIENT(210, 0, "webClient"),
    NETTY_HTTP_CLIENT(210, 0, "nettyHttpClient"),
    MODIFY_RESPONSE(220, 0, "modifyResponse"),
    RPC_PARAM_TRANSFORM(300, 0, "paramTransform"),
    DUBBO(310, 0, "dubbo"),
    SOFA(310, 0, "sofa"),
    TARS(310, 0, "tars"),
    GRPC(310, 0, "grpc"),
    MOTAN(310, 0, "motan"),
    CRYPTOR_RESPONSE(410, 0, "cryptorResponse"),
    RESPONSE(420, 0, "response"),
    KEY_AUTH(430, 0, "keyAuth"),
    BASIC_AUTH(35, 0, "basicAuth");

    private static final Map<String, PluginEnum> PLUGIN_ENUM_MAP;
    private final int code;
    private final int role;
    private final String name;

    private PluginEnum(int code, int role, String name) {
        this.code = code;
        this.role = role;
        this.name = name;
    }

    public int getCode() {
        return this.code;
    }

    public int getRole() {
        return this.role;
    }

    public String getName() {
        return this.name;
    }

    public static PluginEnum getPluginEnumByName(String name) {
        return PLUGIN_ENUM_MAP.getOrDefault(name, GLOBAL);
    }

    public static List<String> getUpstreamNames() {
        return Arrays.asList(PluginEnum.DIVIDE.name, PluginEnum.GRPC.name, PluginEnum.TARS.name, PluginEnum.SPRING_CLOUD.name, PluginEnum.DUBBO.name);
    }

    static {
        PLUGIN_ENUM_MAP = Arrays.stream(PluginEnum.values()).collect(Collectors.toMap(plugin -> plugin.name, plugin -> plugin));
    }
}

