/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.metrics.prometheus.service;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.client.hotspot.DefaultExports;
import io.prometheus.jmx.JmxCollector;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MalformedObjectNameException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.metrics.config.MetricsConfig;
import org.apache.shenyu.metrics.prometheus.collector.BuildInfoCollector;
import org.apache.shenyu.metrics.reporter.MetricsReporter;
import org.apache.shenyu.metrics.spi.MetricsBootService;
import org.apache.shenyu.metrics.spi.MetricsRegister;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public final class PrometheusBootService
implements MetricsBootService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrometheusBootService.class);
    private HTTPServer server;
    private volatile AtomicBoolean registered = new AtomicBoolean(false);

    public void start(MetricsConfig metricsConfig, MetricsRegister metricsRegister) {
        this.startServer(metricsConfig);
        MetricsReporter.register((MetricsRegister)metricsRegister);
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
            this.registered.set(false);
            CollectorRegistry.defaultRegistry.clear();
        }
    }

    private void startServer(MetricsConfig metricsConfig) {
        this.register(metricsConfig.getJmxConfig());
        int port = metricsConfig.getPort();
        String host = metricsConfig.getHost();
        InetSocketAddress inetSocketAddress = null == host || "".equalsIgnoreCase(host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        try {
            this.server = new HTTPServer(inetSocketAddress, CollectorRegistry.defaultRegistry, true);
            log.info(String.format("Prometheus metrics HTTP server `%s:%s` start success.", inetSocketAddress.getHostString(), inetSocketAddress.getPort()));
        }
        catch (IOException ex) {
            log.error("Prometheus metrics HTTP server start fail", (Throwable)ex);
        }
    }

    private void register(String jmxConfig) {
        if (!this.registered.compareAndSet(false, true)) {
            return;
        }
        new BuildInfoCollector().register();
        DefaultExports.initialize();
        try {
            if (StringUtils.isNotEmpty((CharSequence)jmxConfig)) {
                new JmxCollector(jmxConfig).register();
            }
        }
        catch (MalformedObjectNameException e) {
            log.error("init jmx collector error", (Throwable)e);
        }
    }

    @Generated
    public HTTPServer getServer() {
        return this.server;
    }

    @Generated
    public AtomicBoolean getRegistered() {
        return this.registered;
    }
}

