/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.apache.dubbo;

import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.plugin.apache.dubbo.proxy.ApacheDubboProxyService;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.dubbo.common.AbstractDubboPlugin;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ApacheDubboPlugin
extends AbstractDubboPlugin {
    private final ApacheDubboProxyService dubboProxyService;

    public ApacheDubboPlugin(ApacheDubboProxyService dubboProxyService) {
        this.dubboProxyService = dubboProxyService;
    }

    protected Mono<Void> doDubboInvoker(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule, MetaData metaData, String param) {
        RpcContext.getClientAttachment().setAttachment("dubboSelectorId", selector.getId());
        RpcContext.getClientAttachment().setAttachment("dubboRuleId", rule.getId());
        RpcContext.getClientAttachment().setAttachment("dubboRemoteAddress", Objects.requireNonNull(exchange.getRequest().getRemoteAddress()).getAddress().getHostAddress());
        Mono<Object> result = this.dubboProxyService.genericInvoker(param, metaData, exchange);
        return result.then(chain.execute(exchange));
    }

    protected void transmitRpcContext(Map<String, String> rpcContext) {
        RpcContext.getClientAttachment().setAttachments(rpcContext);
    }
}

