/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.api.utils;

import java.util.Objects;
import lombok.Generated;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class WebFluxResultUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebFluxResultUtils.class);

    public static Mono<Void> result(ServerWebExchange exchange, Object result) {
        exchange.getResponse().getHeaders().setContentType(MediaType.APPLICATION_JSON);
        return exchange.getResponse().writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(Objects.requireNonNull(JsonUtils.toJson((Object)result)).getBytes())));
    }

    public static Mono<Void> noSelectorResult(String pluginName, ServerWebExchange exchange) {
        log.error("can not match selector data: {}", (Object)pluginName);
        Object error = ShenyuResultWrap.error(ShenyuResultEnum.SELECTOR_NOT_FOUND.getCode(), ShenyuResultEnum.SELECTOR_NOT_FOUND.getMsg(), null);
        return WebFluxResultUtils.result(exchange, error);
    }

    public static Mono<Void> noRuleResult(String pluginName, ServerWebExchange exchange) {
        log.error("can not match rule data: {}", (Object)pluginName);
        Object error = ShenyuResultWrap.error(ShenyuResultEnum.RULE_NOT_FOUND.getCode(), ShenyuResultEnum.RULE_NOT_FOUND.getMsg(), null);
        return WebFluxResultUtils.result(exchange, error);
    }
}

