/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base;

import java.util.List;
import java.util.Objects;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.HttpParamConverter;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ParamTransformPlugin
implements ShenyuPlugin {
    private final List<HttpMessageReader<?>> messageReaders = HandlerStrategies.withDefaults().messageReaders();

    public Mono<Void> execute(ServerWebExchange exchange, ShenyuPluginChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        if (Objects.nonNull(shenyuContext)) {
            MediaType mediaType = request.getHeaders().getContentType();
            ServerRequest serverRequest = ServerRequest.create((ServerWebExchange)exchange, this.messageReaders);
            if (MediaType.APPLICATION_JSON.isCompatibleWith(mediaType)) {
                return this.body(exchange, serverRequest, chain);
            }
            if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(mediaType)) {
                return this.formData(exchange, serverRequest, chain);
            }
            return this.query(exchange, serverRequest, chain);
        }
        return chain.execute(exchange);
    }

    public int getOrder() {
        return PluginEnum.PARAM_TRANSFORM.getCode();
    }

    public String named() {
        return PluginEnum.PARAM_TRANSFORM.getName();
    }

    private Mono<Void> body(ServerWebExchange exchange, ServerRequest serverRequest, ShenyuPluginChain chain) {
        return serverRequest.bodyToMono(String.class).switchIfEmpty(Mono.defer(() -> Mono.just((Object)""))).flatMap(body -> {
            exchange.getAttributes().put("param_transform", body);
            return chain.execute(exchange);
        });
    }

    private Mono<Void> formData(ServerWebExchange exchange, ServerRequest serverRequest, ShenyuPluginChain chain) {
        return serverRequest.formData().switchIfEmpty(Mono.defer(() -> Mono.just((Object)new LinkedMultiValueMap()))).flatMap(map -> {
            exchange.getAttributes().put("param_transform", HttpParamConverter.toMap(() -> map));
            return chain.execute(exchange);
        });
    }

    private Mono<Void> query(ServerWebExchange exchange, ServerRequest serverRequest, ShenyuPluginChain chain) {
        exchange.getAttributes().put("param_transform", HttpParamConverter.ofString(() -> serverRequest.uri().getQuery()));
        return chain.execute(exchange);
    }

    public Boolean skip(ServerWebExchange exchange) {
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        String rpcType = shenyuContext.getRpcType();
        return !Objects.equals(rpcType, RpcTypeEnum.DUBBO.getName()) && !Objects.equals(rpcType, RpcTypeEnum.GRPC.getName()) && !Objects.equals(rpcType, RpcTypeEnum.TARS.getName()) && !Objects.equals(rpcType, RpcTypeEnum.MOTAN.getName()) && !Objects.equals(rpcType, RpcTypeEnum.SOFA.getName());
    }
}

