/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.cache;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.plugin.base.cache.BaseDataCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;

public class CommonPluginDataSubscriber
implements PluginDataSubscriber {
    private final Map<String, PluginDataHandler> handlerMap;

    public CommonPluginDataSubscriber(List<PluginDataHandler> pluginDataHandlerList) {
        this.handlerMap = pluginDataHandlerList.stream().collect(Collectors.toConcurrentMap(PluginDataHandler::pluginNamed, e -> e));
    }

    public void onSubscribe(PluginData pluginData) {
        this.subscribeDataHandler(pluginData, DataEventTypeEnum.UPDATE);
    }

    public void unSubscribe(PluginData pluginData) {
        this.subscribeDataHandler(pluginData, DataEventTypeEnum.DELETE);
    }

    public void refreshPluginDataAll() {
        BaseDataCache.getInstance().cleanPluginData();
    }

    public void refreshPluginDataSelf(List<PluginData> pluginDataList) {
        if (CollectionUtils.isEmpty(pluginDataList)) {
            return;
        }
        BaseDataCache.getInstance().cleanPluginDataSelf(pluginDataList);
    }

    public void onSelectorSubscribe(SelectorData selectorData) {
        this.subscribeDataHandler(selectorData, DataEventTypeEnum.UPDATE);
    }

    public void unSelectorSubscribe(SelectorData selectorData) {
        this.subscribeDataHandler(selectorData, DataEventTypeEnum.DELETE);
    }

    public void refreshSelectorDataAll() {
        BaseDataCache.getInstance().cleanSelectorData();
    }

    public void refreshSelectorDataSelf(List<SelectorData> selectorDataList) {
        if (CollectionUtils.isEmpty(selectorDataList)) {
            return;
        }
        BaseDataCache.getInstance().cleanSelectorDataSelf(selectorDataList);
    }

    public void onRuleSubscribe(RuleData ruleData) {
        this.subscribeDataHandler(ruleData, DataEventTypeEnum.UPDATE);
    }

    public void unRuleSubscribe(RuleData ruleData) {
        this.subscribeDataHandler(ruleData, DataEventTypeEnum.DELETE);
    }

    public void refreshRuleDataAll() {
        BaseDataCache.getInstance().cleanRuleData();
    }

    public void refreshRuleDataSelf(List<RuleData> ruleDataList) {
        if (CollectionUtils.isEmpty(ruleDataList)) {
            return;
        }
        BaseDataCache.getInstance().cleanRuleDataSelf(ruleDataList);
    }

    private <T> void subscribeDataHandler(T classData, DataEventTypeEnum dataType) {
        Optional.ofNullable(classData).ifPresent(data -> {
            if (data instanceof PluginData) {
                PluginData pluginData = (PluginData)data;
                if (dataType == DataEventTypeEnum.UPDATE) {
                    BaseDataCache.getInstance().cachePluginData(pluginData);
                    Optional.ofNullable(this.handlerMap.get(pluginData.getName())).ifPresent(handler -> handler.handlerPlugin(pluginData));
                } else if (dataType == DataEventTypeEnum.DELETE) {
                    BaseDataCache.getInstance().removePluginData(pluginData);
                    Optional.ofNullable(this.handlerMap.get(pluginData.getName())).ifPresent(handler -> handler.removePlugin(pluginData));
                }
            } else if (data instanceof SelectorData) {
                SelectorData selectorData = (SelectorData)data;
                if (dataType == DataEventTypeEnum.UPDATE) {
                    BaseDataCache.getInstance().cacheSelectData(selectorData);
                    Optional.ofNullable(this.handlerMap.get(selectorData.getPluginName())).ifPresent(handler -> handler.handlerSelector(selectorData));
                } else if (dataType == DataEventTypeEnum.DELETE) {
                    BaseDataCache.getInstance().removeSelectData(selectorData);
                    Optional.ofNullable(this.handlerMap.get(selectorData.getPluginName())).ifPresent(handler -> handler.removeSelector(selectorData));
                }
            } else if (data instanceof RuleData) {
                RuleData ruleData = (RuleData)data;
                if (dataType == DataEventTypeEnum.UPDATE) {
                    BaseDataCache.getInstance().cacheRuleData(ruleData);
                    Optional.ofNullable(this.handlerMap.get(ruleData.getPluginName())).ifPresent(handler -> handler.handlerRule(ruleData));
                } else if (dataType == DataEventTypeEnum.DELETE) {
                    BaseDataCache.getInstance().removeRuleData(ruleData);
                    Optional.ofNullable(this.handlerMap.get(ruleData.getPluginName())).ifPresent(handler -> handler.removeRule(ruleData));
                }
            }
        });
    }
}

