/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.cache;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.PluginHandlerEventEnum;
import org.apache.shenyu.common.enums.TrieCacheTypeEnum;
import org.apache.shenyu.common.enums.TrieEventEnum;
import org.apache.shenyu.common.utils.MapUtils;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.apache.shenyu.plugin.base.cache.BaseDataCache;
import org.apache.shenyu.plugin.base.cache.MatchDataCache;
import org.apache.shenyu.plugin.base.cache.PluginHandlerEvent;
import org.apache.shenyu.plugin.base.event.TrieEvent;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.trie.ShenyuTrie;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.NonNull;

public class CommonPluginDataSubscriber
implements PluginDataSubscriber {
    private static final Logger LOG = LoggerFactory.getLogger(CommonPluginDataSubscriber.class);
    private final Map<String, PluginDataHandler> handlerMap;
    private ApplicationEventPublisher eventPublisher;
    private final ShenyuConfig.SelectorMatchCache selectorMatchConfig;
    private final ShenyuConfig.RuleMatchCache ruleMatchCacheConfig;

    public CommonPluginDataSubscriber(List<PluginDataHandler> pluginDataHandlerList, ShenyuConfig.SelectorMatchCache selectorMatchConfig, ShenyuConfig.RuleMatchCache ruleMatchCacheConfig) {
        this.handlerMap = pluginDataHandlerList.stream().collect(Collectors.toConcurrentMap(PluginDataHandler::pluginNamed, e -> e));
        this.selectorMatchConfig = selectorMatchConfig;
        this.ruleMatchCacheConfig = ruleMatchCacheConfig;
    }

    public CommonPluginDataSubscriber(List<PluginDataHandler> pluginDataHandlerList, ApplicationEventPublisher eventPublisher, ShenyuConfig.SelectorMatchCache selectorMatchConfig, ShenyuConfig.RuleMatchCache ruleMatchCacheConfig) {
        this.handlerMap = pluginDataHandlerList.stream().collect(Collectors.toConcurrentMap(PluginDataHandler::pluginNamed, e -> e));
        this.eventPublisher = eventPublisher;
        this.selectorMatchConfig = selectorMatchConfig;
        this.ruleMatchCacheConfig = ruleMatchCacheConfig;
    }

    public void putExtendPluginDataHandler(List<PluginDataHandler> handlers) {
        if (CollectionUtils.isEmpty(handlers)) {
            return;
        }
        for (PluginDataHandler handler : handlers) {
            String pluginNamed = handler.pluginNamed();
            MapUtils.computeIfAbsent(this.handlerMap, (Object)pluginNamed, name -> {
                LOG.info("shenyu auto add extends plugin data handler name is :{}", (Object)pluginNamed);
                return handler;
            });
        }
    }

    public void onSubscribe(PluginData pluginData) {
        LOG.info("subscribe plugin data for plugin: [id: {}, name: {}, config: {}]", new Object[]{pluginData.getId(), pluginData.getName(), pluginData.getConfig()});
        this.subscribeDataHandler(pluginData, DataEventTypeEnum.UPDATE);
    }

    public void unSubscribe(PluginData pluginData) {
        LOG.info("unSubscribe plugin data for plugin: [id: {}, name: {}]", (Object)pluginData.getId(), (Object)pluginData.getName());
        this.subscribeDataHandler(pluginData, DataEventTypeEnum.DELETE);
    }

    public void refreshPluginDataAll() {
        BaseDataCache.getInstance().cleanPluginData();
    }

    public void refreshPluginDataSelf(List<PluginData> pluginDataList) {
        LOG.info("start refresh plugin data self");
        if (CollectionUtils.isEmpty(pluginDataList)) {
            return;
        }
        BaseDataCache.getInstance().cleanPluginDataSelf(pluginDataList);
    }

    public void onSelectorSubscribe(SelectorData selectorData) {
        LOG.info("subscribe select data for selector: [id: {}, pluginName: {}, name: {}]", new Object[]{selectorData.getId(), selectorData.getPluginName(), selectorData.getName()});
        this.subscribeDataHandler(selectorData, DataEventTypeEnum.UPDATE);
    }

    public void unSelectorSubscribe(SelectorData selectorData) {
        LOG.info("unSubscribe select data for selector: [id: {}, pluginName: {}, name: {}]", new Object[]{selectorData.getId(), selectorData.getPluginName(), selectorData.getName()});
        this.subscribeDataHandler(selectorData, DataEventTypeEnum.DELETE);
    }

    public void refreshSelectorDataAll() {
        LOG.info("start refresh all selector data");
        BaseDataCache.getInstance().cleanSelectorData();
        MatchDataCache.getInstance().cleanSelectorData();
        ShenyuTrie selectorTrie = (ShenyuTrie)SpringBeanUtils.getInstance().getBean(TrieCacheTypeEnum.SELECTOR.getTrieType());
        selectorTrie.clear();
    }

    public void refreshSelectorDataSelf(List<SelectorData> selectorDataList) {
        if (CollectionUtils.isEmpty(selectorDataList)) {
            return;
        }
        BaseDataCache.getInstance().cleanSelectorDataSelf(selectorDataList);
    }

    public void onRuleSubscribe(RuleData ruleData) {
        LOG.info("subscribe rule data for rule[id: {}, selectorId: {}, name: {}]", new Object[]{ruleData.getId(), ruleData.getSelectorId(), ruleData.getName()});
        this.subscribeDataHandler(ruleData, DataEventTypeEnum.UPDATE);
    }

    public void unRuleSubscribe(RuleData ruleData) {
        LOG.info("unSubscribe rule data for rule[id: {}, selectorId: {}, name: {}]", new Object[]{ruleData.getId(), ruleData.getSelectorId(), ruleData.getName()});
        this.subscribeDataHandler(ruleData, DataEventTypeEnum.DELETE);
    }

    public void refreshRuleDataAll() {
        LOG.info("start refresh all rule data");
        BaseDataCache.getInstance().cleanRuleData();
        MatchDataCache.getInstance().cleanRuleDataData();
        ShenyuTrie ruleTrie = (ShenyuTrie)SpringBeanUtils.getInstance().getBean(TrieCacheTypeEnum.RULE.getTrieType());
        ruleTrie.clear();
    }

    public void refreshRuleDataSelf(List<RuleData> ruleDataList) {
        if (CollectionUtils.isEmpty(ruleDataList)) {
            return;
        }
        BaseDataCache.getInstance().cleanRuleDataSelf(ruleDataList);
    }

    private <T> void subscribeDataHandler(T classData, DataEventTypeEnum dataType) {
        if (dataType == DataEventTypeEnum.UPDATE) {
            Optional.ofNullable(classData).ifPresent(data -> this.updateCacheData(classData));
        } else if (dataType == DataEventTypeEnum.DELETE) {
            Optional.ofNullable(classData).ifPresent(data -> this.removeCacheData(classData));
        }
    }

    private <T> void updateCacheData(@NonNull T data) {
        if (data instanceof PluginData) {
            PluginData pluginData = (PluginData)data;
            PluginData oldPluginData = BaseDataCache.getInstance().obtainPluginData(pluginData.getName());
            BaseDataCache.getInstance().cachePluginData(pluginData);
            Optional.ofNullable(this.handlerMap.get(pluginData.getName())).ifPresent(handler -> handler.handlerPlugin(pluginData));
            PluginHandlerEventEnum state = Boolean.TRUE.equals(pluginData.getEnabled()) ? PluginHandlerEventEnum.ENABLED : PluginHandlerEventEnum.DISABLED;
            this.eventPublisher.publishEvent((ApplicationEvent)new PluginHandlerEvent(state, pluginData));
            this.sortPluginIfOrderChange(oldPluginData, pluginData);
            String pluginName = pluginData.getName();
            if (this.selectorMatchConfig.getCache().getEnabled().booleanValue()) {
                MatchDataCache.getInstance().removeSelectorData(pluginName);
            }
            if (this.ruleMatchCacheConfig.getCache().getEnabled().booleanValue()) {
                MatchDataCache.getInstance().removeRuleData(pluginName);
            }
        } else if (data instanceof SelectorData) {
            SelectorData selectorData = (SelectorData)data;
            BaseDataCache.getInstance().cacheSelectData(selectorData);
            Optional.ofNullable(this.handlerMap.get(selectorData.getPluginName())).ifPresent(handler -> handler.handlerSelector(selectorData));
            if (this.selectorMatchConfig.getCache().getEnabled().booleanValue()) {
                MatchDataCache.getInstance().removeSelectorData(selectorData.getPluginName(), selectorData.getId());
                MatchDataCache.getInstance().removeEmptySelectorData(selectorData.getPluginName());
            }
            if (this.ruleMatchCacheConfig.getCache().getEnabled().booleanValue()) {
                MatchDataCache.getInstance().removeRuleDataBySelector(selectorData.getPluginName(), selectorData.getId());
                MatchDataCache.getInstance().removeEmptyRuleData(selectorData.getPluginName());
            }
            this.updateSelectorTrieCache(selectorData);
        } else if (data instanceof RuleData) {
            RuleData ruleData = (RuleData)data;
            BaseDataCache.getInstance().cacheRuleData(ruleData);
            Optional.ofNullable(this.handlerMap.get(ruleData.getPluginName())).ifPresent(handler -> handler.handlerRule(ruleData));
            if (this.ruleMatchCacheConfig.getCache().getEnabled().booleanValue()) {
                MatchDataCache.getInstance().removeRuleData(ruleData.getPluginName(), ruleData.getId());
                MatchDataCache.getInstance().removeEmptyRuleData(ruleData.getPluginName());
            }
            this.updateRuleTrieCache(ruleData);
        }
    }

    private void sortPluginIfOrderChange(PluginData oldPluginData, PluginData pluginData) {
        if (Objects.isNull(this.eventPublisher) || Objects.isNull(pluginData.getSort())) {
            return;
        }
        if (Objects.isNull(oldPluginData) || Objects.isNull(oldPluginData.getSort()) || !Objects.equals(oldPluginData.getSort(), pluginData.getSort())) {
            this.eventPublisher.publishEvent((ApplicationEvent)new PluginHandlerEvent(PluginHandlerEventEnum.SORTED, pluginData));
        }
    }

    private <T> void removeCacheData(@NonNull T data) {
        if (data instanceof PluginData) {
            PluginData pluginData = (PluginData)data;
            BaseDataCache.getInstance().removePluginData(pluginData);
            Optional.ofNullable(this.handlerMap.get(pluginData.getName())).ifPresent(handler -> handler.removePlugin(pluginData));
            this.eventPublisher.publishEvent((ApplicationEvent)new PluginHandlerEvent(PluginHandlerEventEnum.DELETE, pluginData));
        } else if (data instanceof SelectorData) {
            SelectorData selectorData = (SelectorData)data;
            BaseDataCache.getInstance().removeSelectData(selectorData);
            Optional.ofNullable(this.handlerMap.get(selectorData.getPluginName())).ifPresent(handler -> handler.removeSelector(selectorData));
            if (this.selectorMatchConfig.getCache().getEnabled().booleanValue()) {
                MatchDataCache.getInstance().removeSelectorData(selectorData.getPluginName(), selectorData.getId());
                MatchDataCache.getInstance().removeEmptySelectorData(selectorData.getPluginName());
            }
            if (this.selectorMatchConfig.getTrie().getEnabled().booleanValue()) {
                this.eventPublisher.publishEvent((ApplicationEvent)new TrieEvent(TrieEventEnum.REMOVE, TrieCacheTypeEnum.SELECTOR, selectorData));
            }
        } else if (data instanceof RuleData) {
            RuleData ruleData = (RuleData)data;
            BaseDataCache.getInstance().removeRuleData(ruleData);
            Optional.ofNullable(this.handlerMap.get(ruleData.getPluginName())).ifPresent(handler -> handler.removeRule(ruleData));
            if (this.ruleMatchCacheConfig.getCache().getEnabled().booleanValue()) {
                MatchDataCache.getInstance().removeRuleData(ruleData.getPluginName(), ruleData.getId());
                MatchDataCache.getInstance().removeEmptyRuleData(ruleData.getPluginName());
            }
            if (this.ruleMatchCacheConfig.getTrie().getEnabled().booleanValue()) {
                this.eventPublisher.publishEvent((ApplicationEvent)new TrieEvent(TrieEventEnum.REMOVE, TrieCacheTypeEnum.RULE, ruleData));
            }
        }
    }

    private void updateSelectorTrieCache(SelectorData selectorData) {
        if (!this.selectorMatchConfig.getTrie().getEnabled().booleanValue()) {
            return;
        }
        if (Boolean.TRUE.equals(selectorData.getEnabled())) {
            if (CollectionUtils.isEmpty((Collection)selectorData.getBeforeConditionList())) {
                this.eventPublisher.publishEvent((ApplicationEvent)new TrieEvent(TrieEventEnum.INSERT, TrieCacheTypeEnum.SELECTOR, selectorData));
            } else {
                this.eventPublisher.publishEvent((ApplicationEvent)new TrieEvent(TrieEventEnum.UPDATE, TrieCacheTypeEnum.SELECTOR, selectorData));
            }
        } else {
            this.eventPublisher.publishEvent((ApplicationEvent)new TrieEvent(TrieEventEnum.REMOVE, TrieCacheTypeEnum.SELECTOR, selectorData));
        }
    }

    private void updateRuleTrieCache(RuleData ruleData) {
        if (!this.ruleMatchCacheConfig.getTrie().getEnabled().booleanValue()) {
            return;
        }
        if (Boolean.TRUE.equals(ruleData.getEnabled())) {
            if (CollectionUtils.isEmpty((Collection)ruleData.getBeforeConditionDataList())) {
                this.eventPublisher.publishEvent((ApplicationEvent)new TrieEvent(TrieEventEnum.INSERT, TrieCacheTypeEnum.RULE, ruleData));
            } else {
                this.eventPublisher.publishEvent((ApplicationEvent)new TrieEvent(TrieEventEnum.UPDATE, TrieCacheTypeEnum.RULE, ruleData));
            }
        } else {
            this.eventPublisher.publishEvent((ApplicationEvent)new TrieEvent(TrieEventEnum.REMOVE, TrieCacheTypeEnum.RULE, ruleData));
        }
    }
}

