/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.cache;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shenyu.common.dto.ProxySelectorData;
import org.apache.shenyu.plugin.base.handler.ProxySelectorDataHandler;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;

public class CommonProxySelectorDataSubscriber
implements ProxySelectorDataSubscriber {
    private final Map<String, ProxySelectorDataHandler> handlerMap;

    public CommonProxySelectorDataSubscriber(List<ProxySelectorDataHandler> proxySelectorDataHandlerList) {
        this.handlerMap = proxySelectorDataHandlerList.stream().collect(Collectors.toConcurrentMap(ProxySelectorDataHandler::pluginName, e -> e));
    }

    public void onSubscribe(ProxySelectorData proxySelectorData) {
        Optional.ofNullable(this.handlerMap.get(proxySelectorData.getPluginName())).ifPresent(handler -> handler.handlerProxySelector(proxySelectorData));
    }

    public void unSubscribe(ProxySelectorData proxySelectorData) {
        Optional.ofNullable(this.handlerMap.get(proxySelectorData.getPluginName())).ifPresent(handler -> handler.removeProxySelector(proxySelectorData.getName()));
    }

    public void refresh() {
        super.refresh();
    }
}

