/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.cache;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.shenyu.common.cache.WindowTinyLFUMap;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.plugin.base.utils.PathMatchUtils;

public final class MetaDataCache {
    private static final String DIVIDE_CACHE_KEY = "";
    private static final MetaData NULL = new MetaData();
    private static final MetaDataCache INSTANCE = new MetaDataCache();
    private static final ConcurrentMap<String, MetaData> META_DATA_MAP = Maps.newConcurrentMap();
    private static final WindowTinyLFUMap<String, MetaData> CACHE = new WindowTinyLFUMap(65536, Integer.MAX_VALUE, Boolean.FALSE);
    private static final ConcurrentMap<String, Set<String>> MAPPING = Maps.newConcurrentMap();

    private MetaDataCache() {
    }

    public static MetaDataCache getInstance() {
        return INSTANCE;
    }

    public void cache(MetaData data) {
        if (META_DATA_MAP.containsKey(data.getId())) {
            this.clean(((MetaData)META_DATA_MAP.get(data.getId())).getPath());
        }
        META_DATA_MAP.put(data.getId(), data);
        String path = data.getPath();
        this.clean(path);
        if (!path.contains("*")) {
            this.initCache(path, data, path);
        }
    }

    public void remove(MetaData data) {
        META_DATA_MAP.remove(data.getId());
        this.clean(data.getPath());
    }

    private void clean(String key) {
        Optional.ofNullable(MAPPING.get(key)).ifPresent(paths -> {
            for (String path : paths) {
                CACHE.remove((Object)path);
            }
        });
    }

    public void clean() {
        this.clean(DIVIDE_CACHE_KEY);
    }

    public MetaData obtain(String path) {
        MetaData metaData = Optional.ofNullable(CACHE.get((Object)path)).orElseGet(() -> {
            MetaData value = META_DATA_MAP.values().stream().filter(data -> PathMatchUtils.match(data.getPath(), path)).findFirst().orElse(null);
            String metaPath = Optional.ofNullable(value).map(MetaData::getPath).orElse(DIVIDE_CACHE_KEY);
            this.initCache(path, value, metaPath);
            return value;
        });
        return NULL.equals((Object)metaData) ? null : metaData;
    }

    public void initCache(String path, MetaData value, String metaPath) {
        CACHE.put((Object)path, (Object)Optional.ofNullable(value).orElse(NULL));
        Set paths = (Set)MAPPING.get(metaPath);
        if (Objects.isNull(paths)) {
            MAPPING.putIfAbsent(metaPath, new ConcurrentSkipListSet());
            paths = (Set)MAPPING.get(metaPath);
        }
        paths.add(path);
    }

    public Map<String, MetaData> getMetaDataMap() {
        return META_DATA_MAP;
    }

    public Map<String, MetaData> getMetaDataCache() {
        return CACHE;
    }
}

