/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.support;

import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public class ResponseDecorator
extends ServerHttpResponseDecorator {
    private final ServerWebExchange exchange;
    private final Function<String, String> convert;

    public ResponseDecorator(ServerWebExchange exchange, Function<String, String> convert) {
        super(exchange.getResponse());
        this.exchange = exchange;
        this.convert = convert;
    }

    @NonNull
    public Mono<Void> writeWith(@NonNull Publisher<? extends DataBuffer> body) {
        Mono dataBufferMono = DataBufferUtils.join(body);
        return dataBufferMono.flatMap(dataBuffer -> {
            byte[] bytes = new byte[dataBuffer.readableByteCount()];
            dataBuffer.read(bytes);
            String bodyString = new String(bytes, StandardCharsets.UTF_8);
            String convertStr = this.convert.apply(bodyString);
            return WebFluxResultUtils.result((ServerWebExchange)this.exchange, (Object)convertStr);
        });
    }
}

