/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.divide.balance.spi;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.convert.DivideUpstream;
import org.apache.shenyu.plugin.divide.balance.LoadBalance;

public abstract class AbstractLoadBalance
implements LoadBalance {
    protected abstract DivideUpstream doSelect(List<DivideUpstream> var1, String var2);

    @Override
    public DivideUpstream select(List<DivideUpstream> upstreamList, String ip) {
        if (CollectionUtils.isEmpty(upstreamList)) {
            return null;
        }
        if (upstreamList.size() == 1) {
            return upstreamList.get(0);
        }
        return this.doSelect(upstreamList, ip);
    }

    protected int getWeight(DivideUpstream upstream) {
        if (!upstream.isStatus()) {
            return 0;
        }
        return this.getWeight(upstream.getTimestamp(), this.getWarmup(upstream.getWarmup(), 600000), upstream.getWeight());
    }

    private int getWeight(long timestamp, int warmup, int weight) {
        int uptime;
        if (weight > 0 && timestamp > 0L && (uptime = (int)(System.currentTimeMillis() - timestamp)) > 0 && uptime < warmup) {
            return this.calculateWarmupWeight(uptime, warmup, weight);
        }
        return weight;
    }

    private int getWarmup(int warmup, int defaultWarmup) {
        if (warmup > 0) {
            return warmup;
        }
        return defaultWarmup;
    }

    private int calculateWarmupWeight(int uptime, int warmup, int weight) {
        int ww = (int)((float)uptime / ((float)warmup / (float)weight));
        return ww < 1 ? 1 : Math.min(ww, weight);
    }
}

