/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.divide.balance.spi;

import java.util.List;
import java.util.Random;
import org.apache.shenyu.common.dto.convert.DivideUpstream;
import org.apache.shenyu.plugin.divide.balance.spi.AbstractLoadBalance;
import org.apache.shenyu.spi.Join;

@Join
public class RandomLoadBalance
extends AbstractLoadBalance {
    private static final Random RANDOM = new Random();

    @Override
    public DivideUpstream doSelect(List<DivideUpstream> upstreamList, String ip) {
        int totalWeight = this.calculateTotalWeight(upstreamList);
        boolean sameWeight = this.isAllUpStreamSameWeight(upstreamList);
        if (totalWeight > 0 && !sameWeight) {
            return this.random(totalWeight, upstreamList);
        }
        return this.random(upstreamList);
    }

    private boolean isAllUpStreamSameWeight(List<DivideUpstream> upstreamList) {
        boolean sameWeight = true;
        int length = upstreamList.size();
        for (int i = 0; i < length; ++i) {
            int weight = this.getWeight(upstreamList.get(i));
            if (i <= 0 || weight == this.getWeight(upstreamList.get(i - 1))) continue;
            sameWeight = false;
            break;
        }
        return sameWeight;
    }

    private int calculateTotalWeight(List<DivideUpstream> upstreamList) {
        int totalWeight = 0;
        for (DivideUpstream divideUpstream : upstreamList) {
            int weight = this.getWeight(divideUpstream);
            totalWeight += weight;
        }
        return totalWeight;
    }

    private DivideUpstream random(int totalWeight, List<DivideUpstream> upstreamList) {
        int offset = RANDOM.nextInt(totalWeight);
        for (DivideUpstream divideUpstream : upstreamList) {
            if ((offset -= this.getWeight(divideUpstream)) >= 0) continue;
            return divideUpstream;
        }
        return upstreamList.get(0);
    }

    private DivideUpstream random(List<DivideUpstream> upstreamList) {
        return upstreamList.get(RANDOM.nextInt(upstreamList.size()));
    }
}

