/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.divide.balance.spi;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.shenyu.common.dto.convert.DivideUpstream;
import org.apache.shenyu.plugin.divide.balance.spi.AbstractLoadBalance;
import org.apache.shenyu.spi.Join;

@Join
public class RoundRobinLoadBalance
extends AbstractLoadBalance {
    private final int recyclePeriod = 60000;
    private final ConcurrentMap<String, ConcurrentMap<String, WeightedRoundRobin>> methodWeightMap = new ConcurrentHashMap<String, ConcurrentMap<String, WeightedRoundRobin>>(16);
    private final AtomicBoolean updateLock = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DivideUpstream doSelect(List<DivideUpstream> upstreamList, String ip) {
        String key = upstreamList.get(0).getUpstreamUrl();
        ConcurrentMap map = (ConcurrentMap)this.methodWeightMap.get(key);
        if (map == null) {
            this.methodWeightMap.putIfAbsent(key, new ConcurrentHashMap(16));
            map = (ConcurrentMap)this.methodWeightMap.get(key);
        }
        int totalWeight = 0;
        long maxCurrent = Long.MIN_VALUE;
        long now = System.currentTimeMillis();
        DivideUpstream selectedInvoker = null;
        WeightedRoundRobin selectedWRR = null;
        for (DivideUpstream upstream : upstreamList) {
            String rKey = upstream.getUpstreamUrl();
            WeightedRoundRobin weightedRoundRobin = (WeightedRoundRobin)map.get(rKey);
            int weight = this.getWeight(upstream);
            if (weightedRoundRobin == null) {
                weightedRoundRobin = new WeightedRoundRobin();
                weightedRoundRobin.setWeight(weight);
                map.putIfAbsent(rKey, weightedRoundRobin);
            }
            if (weight != weightedRoundRobin.getWeight()) {
                weightedRoundRobin.setWeight(weight);
            }
            long cur = weightedRoundRobin.increaseCurrent();
            weightedRoundRobin.setLastUpdate(now);
            if (cur > maxCurrent) {
                maxCurrent = cur;
                selectedInvoker = upstream;
                selectedWRR = weightedRoundRobin;
            }
            totalWeight += weight;
        }
        if (!this.updateLock.get() && upstreamList.size() != map.size() && this.updateLock.compareAndSet(false, true)) {
            try {
                ConcurrentHashMap newMap = new ConcurrentHashMap(map);
                newMap.entrySet().removeIf(item -> now - ((WeightedRoundRobin)item.getValue()).getLastUpdate() > 60000L);
                this.methodWeightMap.put(key, newMap);
            }
            finally {
                this.updateLock.set(false);
            }
        }
        if (selectedInvoker != null) {
            selectedWRR.sel(totalWeight);
            return selectedInvoker;
        }
        return upstreamList.get(0);
    }

    protected static class WeightedRoundRobin {
        private int weight;
        private final AtomicLong current = new AtomicLong(0L);
        private long lastUpdate;

        protected WeightedRoundRobin() {
        }

        int getWeight() {
            return this.weight;
        }

        void setWeight(int weight) {
            this.weight = weight;
            this.current.set(0L);
        }

        long increaseCurrent() {
            return this.current.addAndGet(this.weight);
        }

        void sel(int total) {
            this.current.addAndGet(-1 * total);
        }

        long getLastUpdate() {
            return this.lastUpdate;
        }

        void setLastUpdate(long lastUpdate) {
            this.lastUpdate = lastUpdate;
        }
    }
}

