/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.divide.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.DivideUpstream;
import org.apache.shenyu.common.dto.convert.rule.impl.DivideRuleHandle;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.UpstreamCheckUtils;
import org.apache.shenyu.plugin.base.cache.RuleHandleCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UpstreamCacheManager
extends RuleHandleCache<String, DivideRuleHandle> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpstreamCacheManager.class);
    private static final UpstreamCacheManager INSTANCE = new UpstreamCacheManager();
    private static final Map<String, List<DivideUpstream>> UPSTREAM_MAP = Maps.newConcurrentMap();
    private static final Map<String, List<DivideUpstream>> UPSTREAM_MAP_TEMP = Maps.newConcurrentMap();

    private UpstreamCacheManager() {
        boolean check = Boolean.parseBoolean(System.getProperty("shenyu.upstream.check", "false"));
        if (check) {
            new ScheduledThreadPoolExecutor(1, ShenyuThreadFactory.create((String)"scheduled-upstream-task", (boolean)false)).scheduleWithFixedDelay(this::scheduled, 30L, Integer.parseInt(System.getProperty("shenyu.upstream.scheduledTime", "30")), TimeUnit.SECONDS);
        }
    }

    public static UpstreamCacheManager getInstance() {
        return INSTANCE;
    }

    public List<DivideUpstream> findUpstreamListBySelectorId(String selectorId) {
        return UPSTREAM_MAP_TEMP.get(selectorId);
    }

    public void removeByKey(String key) {
        UPSTREAM_MAP_TEMP.remove(key);
    }

    public void submit(SelectorData selectorData) {
        List upstreamList = GsonUtils.getInstance().fromList(selectorData.getHandle(), DivideUpstream.class);
        if (null != upstreamList && upstreamList.size() > 0) {
            UPSTREAM_MAP.put(selectorData.getId(), upstreamList);
            UPSTREAM_MAP_TEMP.put(selectorData.getId(), upstreamList);
        } else {
            UPSTREAM_MAP.remove(selectorData.getId());
            UPSTREAM_MAP_TEMP.remove(selectorData.getId());
        }
    }

    private void scheduled() {
        if (UPSTREAM_MAP.size() > 0) {
            UPSTREAM_MAP.forEach((k, v) -> {
                List<DivideUpstream> result = this.check((List<DivideUpstream>)v);
                if (result.size() > 0) {
                    UPSTREAM_MAP_TEMP.put((String)k, result);
                } else {
                    UPSTREAM_MAP_TEMP.remove(k);
                }
            });
        }
    }

    private List<DivideUpstream> check(List<DivideUpstream> upstreamList) {
        ArrayList resultList = Lists.newArrayListWithCapacity((int)upstreamList.size());
        for (DivideUpstream divideUpstream : upstreamList) {
            boolean pass = UpstreamCheckUtils.checkUrl((String)divideUpstream.getUpstreamUrl());
            if (pass) {
                if (!divideUpstream.isStatus()) {
                    divideUpstream.setTimestamp(System.currentTimeMillis());
                    divideUpstream.setStatus(true);
                    log.info("UpstreamCacheManager detect success the url: {}, host: {} ", (Object)divideUpstream.getUpstreamUrl(), (Object)divideUpstream.getUpstreamHost());
                }
                resultList.add(divideUpstream);
                continue;
            }
            divideUpstream.setStatus(false);
            log.error("check the url={} is fail ", (Object)divideUpstream.getUpstreamUrl());
        }
        return resultList;
    }
}

