/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.divide.handler;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.loadbalancer.cache.UpstreamCacheManager;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.plugin.base.cache.MetaDataCache;
import org.apache.shenyu.plugin.base.handler.DiscoveryUpstreamDataHandler;
import org.springframework.util.ObjectUtils;

public class DivideUpstreamDataHandler
implements DiscoveryUpstreamDataHandler {
    public void handlerDiscoveryUpstreamData(DiscoverySyncData discoverySyncData) {
        if (Objects.isNull(discoverySyncData) || Objects.isNull(discoverySyncData.getSelectorId())) {
            return;
        }
        List upstreamList = discoverySyncData.getUpstreamDataList();
        UpstreamCacheManager.getInstance().submit(discoverySyncData.getSelectorId(), this.convertUpstreamList(upstreamList));
        MetaDataCache.getInstance().clean();
    }

    public String pluginName() {
        return PluginEnum.DIVIDE.getName();
    }

    private List<Upstream> convertUpstreamList(List<DiscoveryUpstreamData> upstreamList) {
        if (ObjectUtils.isEmpty(upstreamList)) {
            return Collections.emptyList();
        }
        return upstreamList.stream().map(u -> {
            Properties properties = Optional.ofNullable(u.getProps()).map(ps -> (Properties)GsonUtils.getInstance().fromJson(ps, Properties.class)).orElse(new Properties());
            return Upstream.builder().protocol(u.getProtocol()).url(u.getUrl()).weight(u.getWeight()).warmup(Integer.parseInt(properties.getProperty("warmup", "10"))).status(0 == u.getStatus()).timestamp(Optional.ofNullable(u.getDateCreated()).map(Timestamp::getTime).orElse(System.currentTimeMillis()).longValue()).build();
        }).collect(Collectors.toList());
    }
}

