/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.global;

import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.context.ShenyuContextBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GlobalPlugin
implements ShenyuPlugin {
    private final ShenyuContextBuilder builder;

    public GlobalPlugin(ShenyuContextBuilder builder) {
        this.builder = builder;
    }

    public Mono<Void> execute(ServerWebExchange exchange, ShenyuPluginChain chain) {
        ShenyuContext shenyuContext;
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders headers = request.getHeaders();
        String upgrade = headers.getFirst("Upgrade");
        if (StringUtils.isBlank((CharSequence)upgrade) || !"websocket".equals(upgrade)) {
            shenyuContext = this.builder.build(exchange);
        } else {
            MultiValueMap queryParams = request.getQueryParams();
            shenyuContext = this.transformMap((MultiValueMap<String, String>)queryParams);
        }
        exchange.getAttributes().put("context", shenyuContext);
        return chain.execute(exchange);
    }

    public int getOrder() {
        return PluginEnum.GLOBAL.getCode();
    }

    private ShenyuContext transformMap(MultiValueMap<String, String> queryParams) {
        ShenyuContext shenyuContext = new ShenyuContext();
        shenyuContext.setModule((String)queryParams.getFirst((Object)"module"));
        shenyuContext.setMethod((String)queryParams.getFirst((Object)"method"));
        shenyuContext.setRpcType((String)queryParams.getFirst((Object)"rpcType"));
        return shenyuContext;
    }

    public String named() {
        return PluginEnum.GLOBAL.getName();
    }
}

