/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc;

import io.grpc.CallOptions;
import io.grpc.Context;
import io.grpc.MethodDescriptor;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.ResultEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.grpc.cache.GrpcClientCache;
import org.apache.shenyu.plugin.grpc.client.ShenyuGrpcClient;
import org.apache.shenyu.plugin.grpc.context.GrpcConstants;
import org.apache.shenyu.plugin.grpc.proto.ShenyuGrpcResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GrpcPlugin
extends AbstractShenyuPlugin {
    public static final Context.Key<Map<String, String>> RPC_CONTEXT_KEY = Context.key((String)"shenyuRpcContext");
    private static final Logger LOG = LoggerFactory.getLogger(GrpcPlugin.class);

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        String param = (String)exchange.getAttribute("param_transform");
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        MetaData metaData = (MetaData)exchange.getAttribute("metaData");
        if (!this.checkMetaData(metaData)) {
            LOG.error(" path is :{}, meta data have error.... {}", (Object)shenyuContext.getPath(), (Object)metaData);
            exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.META_DATA_ERROR);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        assert (metaData != null);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{metaData.getParameterTypes()}) && StringUtils.isBlank((CharSequence)param)) {
            exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.GRPC_HAVE_BODY_PARAM);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        ShenyuGrpcClient client = GrpcClientCache.getGrpcClient(selector.getId());
        if (Objects.isNull(client)) {
            exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.GRPC_CLIENT_NULL);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        Context.current().withValue(GrpcConstants.GRPC_SELECTOR_ID, (Object)selector.getId()).attach();
        Context.current().withValue(GrpcConstants.GRPC_RULE_ID, (Object)rule.getId()).attach();
        Context.current().withValue(GrpcConstants.GRPC_REMOTE_ADDRESS, (Object)Objects.requireNonNull(exchange.getRequest().getRemoteAddress()).getAddress().getHostAddress()).attach();
        GrpcExtInfo extInfo = (GrpcExtInfo)GsonUtils.getGson().fromJson(metaData.getRpcExt(), GrpcExtInfo.class);
        CallOptions callOptions = CallOptions.DEFAULT.withDeadlineAfter((long)extInfo.timeout.intValue(), TimeUnit.MILLISECONDS);
        Map rpcContext = (Map)exchange.getAttribute("generalContext");
        Optional.ofNullable(rpcContext).map(context -> (Map)context.get(PluginEnum.GRPC.getName())).ifPresent(context -> Context.current().withValue(RPC_CONTEXT_KEY, context).attach());
        CompletableFuture<ShenyuGrpcResponse> result = client.call(metaData, callOptions, param, extInfo.methodType);
        Context.current().detach(Context.ROOT);
        return Mono.fromFuture((CompletableFuture)result.thenApply(ret -> {
            exchange.getAttributes().put("rpc_result", ret.getResults());
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.SUCCESS.getName());
            return ret;
        })).onErrorMap(ShenyuException::new).then(chain.execute(exchange));
    }

    public String named() {
        return PluginEnum.GRPC.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        return this.skipExcept(exchange, new RpcTypeEnum[]{RpcTypeEnum.GRPC});
    }

    public int getOrder() {
        return PluginEnum.GRPC.getCode();
    }

    private boolean checkMetaData(MetaData metaData) {
        return Objects.nonNull(metaData) && !StringUtils.isBlank((CharSequence)metaData.getMethodName()) && !StringUtils.isBlank((CharSequence)metaData.getServiceName());
    }

    protected Mono<Void> handleSelectorIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return WebFluxResultUtils.noSelectorResult((String)pluginName, (ServerWebExchange)exchange);
    }

    protected Mono<Void> handleRuleIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return WebFluxResultUtils.noRuleResult((String)pluginName, (ServerWebExchange)exchange);
    }

    static class GrpcExtInfo {
        private Integer timeout = 5000;
        private MethodDescriptor.MethodType methodType;

        GrpcExtInfo() {
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public MethodDescriptor.MethodType getMethodType() {
            return this.methodType;
        }

        public void setMethodType(MethodDescriptor.MethodType methodType) {
            this.methodType = methodType;
        }
    }
}

