/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.loadbalance;

import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import java.util.Objects;
import org.apache.shenyu.plugin.grpc.loadbalance.SubChannels;

public class SubChannelCopy {
    private final int weight;
    private final String status;
    private final String url;
    private final LoadBalancer.Subchannel channel;
    private final EquivalentAddressGroup addressGroup;
    private final ConnectivityStateInfo state;

    public SubChannelCopy(LoadBalancer.Subchannel channel) {
        this.channel = channel;
        this.addressGroup = channel.getAddresses();
        this.weight = SubChannels.getWeight(channel);
        this.state = SubChannels.getStateInfo(channel);
        this.status = SubChannels.getStatus(channel);
        this.url = SubChannels.getUrl(channel);
    }

    public int getWeight() {
        return this.weight;
    }

    public String getStatus() {
        return this.status;
    }

    public LoadBalancer.Subchannel getChannel() {
        return this.channel;
    }

    public EquivalentAddressGroup getAddressGroup() {
        return this.addressGroup;
    }

    public ConnectivityStateInfo getState() {
        return this.state;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubChannelCopy that = (SubChannelCopy)o;
        return this.weight == that.weight && Objects.equals(this.status, that.status) && Objects.equals(this.channel, that.channel) && Objects.equals(this.addressGroup, that.addressGroup) && Objects.equals(this.state, that.state) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.weight, this.status, this.channel, this.addressGroup, this.state, this.url);
    }
}

