/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.loadbalance.picker;

import io.grpc.ConnectivityState;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.plugin.grpc.loadbalance.SubChannelCopy;
import org.apache.shenyu.plugin.grpc.loadbalance.picker.AbstractPicker;
import org.apache.shenyu.plugin.grpc.loadbalance.picker.Picker;

public abstract class AbstractReadyPicker
extends AbstractPicker
implements Picker {
    private final boolean hasIdleNode;
    private final List<SubChannelCopy> list;

    AbstractReadyPicker(List<LoadBalancer.Subchannel> list) {
        this.list = list.stream().map(SubChannelCopy::new).collect(Collectors.toList());
        this.hasIdleNode = this.hasIdleNode();
    }

    private boolean hasIdleNode() {
        return this.list.stream().anyMatch(r -> r.getState().getState() == ConnectivityState.IDLE || r.getState().getState() == ConnectivityState.CONNECTING);
    }

    public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
        List<SubChannelCopy> list = this.getSubchannels();
        if (CollectionUtils.isEmpty(list)) {
            return this.getErrorPickResult();
        }
        SubChannelCopy channel = this.pick(list);
        return Objects.isNull(channel) ? this.getErrorPickResult() : LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)channel.getChannel());
    }

    protected abstract SubChannelCopy pick(List<SubChannelCopy> var1);

    @Override
    public List<SubChannelCopy> getSubchannels() {
        return this.list.stream().filter(r -> r.getState().getState() == ConnectivityState.READY && Boolean.parseBoolean(r.getStatus())).collect(Collectors.toList());
    }

    private LoadBalancer.PickResult getErrorPickResult() {
        if (this.hasIdleNode) {
            return LoadBalancer.PickResult.withNoResult();
        }
        return LoadBalancer.PickResult.withError((Status)Status.UNAVAILABLE.withCause((Throwable)new NoSuchElementException()).withDescription("can not find the subChannel"));
    }

    @Override
    public boolean isEquivalentTo(AbstractPicker picker) {
        if (!(picker instanceof AbstractReadyPicker)) {
            return false;
        }
        AbstractReadyPicker other = (AbstractReadyPicker)picker;
        return other == this || this.list.size() == other.list.size() && new HashSet<SubChannelCopy>(this.list).containsAll(other.list);
    }

    @Override
    public String getSubchannelsInfo() {
        List infos = this.list.stream().map(r -> "Subchannel{ weight=" + r.getWeight() + ", readyState=\"" + r.getState().toString() + "\", address=\"" + r.getChannel().getAddresses() + "\"}").collect(Collectors.toList());
        return "[ " + String.join((CharSequence)",", infos) + " ]";
    }
}

